@extends('layouts.admin')

@section('title', 'Create Country')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Create New Country</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.countries.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="code" class="form-label">Country Code *</label>
                                <input type="text" class="form-control @error('code') is-invalid @enderror" 
                                       id="code" name="code" value="{{ old('code') }}" 
                                       placeholder="e.g., US" maxlength="2" required>
                                @error('code')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">2-letter ISO country code</small>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="name" class="form-label">Country Name *</label>
                                <input type="text" class="form-control @error('name') is-invalid @enderror" 
                                       id="name" name="name" value="{{ old('name') }}"
                                       placeholder="e.g., United States" required>
                                @error('name')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="region" class="form-label">Trade Region</label>
                                <select class="form-control @error('region') is-invalid @enderror" 
                                        id="region" name="region">
                                    <option value="">Select Region</option>
                                    <option value="EAC" {{ old('region') == 'EAC' ? 'selected' : '' }}>East African Community (EAC)</option>
                                    <option value="COMESA" {{ old('region') == 'COMESA' ? 'selected' : '' }}>Common Market for Eastern and Southern Africa (COMESA)</option>
                                    <option value="EU" {{ old('region') == 'EU' ? 'selected' : '' }}>European Union</option>
                                    <option value="OTHER" {{ old('region') == 'OTHER' ? 'selected' : '' }}>Other</option>
                                </select>
                                @error('region')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-3">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input" id="active" name="active" value="1" {{ old('active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="active">Active</label>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Country
                        </button>
                        <a href="{{ route('admin.countries.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Country Guidelines</h5>
            </div>
            <div class="card-body">
                <h6>Country Codes</h6>
                <ul class="small">
                    <li>Use 2-letter ISO codes (e.g., US, GB, KE)</li>
                    <li>Must be unique</li>
                    <li>Case insensitive</li>
                </ul>
                
                <h6>Trade Regions</h6>
                <ul class="small">
                    <li><strong>EAC:</strong> East African Community members</li>
                    <li><strong>COMESA:</strong> Common Market members</li>
                    <li><strong>EU:</strong> European Union members</li>
                    <li><strong>Other:</strong> All other countries</li>
                </ul>
                
                <h6>Regional Preferences</h6>
                <p class="small">EAC and COMESA countries may have preferential duty rates.</p>
            </div>
        </div>
    </div>
</div>
@endsection