@extends('layouts.admin')

@section('title', 'Contact Submission - Conversation')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('admin.contact-submissions.index') }}">Contact Submissions</a></li>
                        <li class="breadcrumb-item active">Conversation</li>
                    </ol>
                </div>
                <h4 class="page-title">Conversation - {{ $submission->subject }}</h4>
            </div>

            <div class="row">
                <!-- Conversation Panel -->
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                            <h5 class="card-title mb-0">Conversation Thread</h5>
                            <div class="badge bg-light text-dark">
                                {{ $submission->message_count }} messages
                            </div>
                        </div>
                        <div class="card-body">
                            <!-- Conversation Messages -->
                            <div class="conversation-messages" style="max-height: 500px; overflow-y: auto;">
                                @foreach($submission->messages->sortBy('created_at') as $message)
                                <div class="message mb-4 {{ $message->isOutgoing() ? 'message-outgoing' : 'message-incoming' }}">
                                    <div class="d-flex {{ $message->isOutgoing() ? 'justify-content-end' : 'justify-content-start' }}">
                                        <div class="message-bubble {{ $message->isOutgoing() ? 'bg-primary text-white' : 'bg-light' }} 
                                                    rounded p-3 shadow-sm" style="max-width: 70%;">
                                            <div class="message-header d-flex justify-content-between align-items-center mb-2">
                                                <small class="{{ $message->isOutgoing() ? 'text-white-50' : 'text-muted' }} fw-bold">
                                                    {{ $message->getSenderName() }}
                                                </small>
                                                <small class="{{ $message->isOutgoing() ? 'text-white-50' : 'text-muted' }}">
                                                    {{ $message->created_at->format('M j, g:i A') }}
                                                </small>
                                            </div>
                                            <div class="message-content">
                                                {!! nl2br(e($message->message)) !!}
                                            </div>
                                            @if($message->isOutgoing() && $message->user)
                                            <div class="message-footer mt-2">
                                                <small class="{{ $message->isOutgoing() ? 'text-white-50' : 'text-muted' }}">
                                                    Sent by {{ $message->user->name }}
                                                </small>
                                            </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </div>

                            <!-- Response Form -->
                            <div class="response-form mt-4">
                                <form action="{{ route('admin.contact-submissions.send-response', $submission->id) }}" method="POST">
                                    @csrf
                                    <div class="mb-3">
                                        <label for="response_message" class="form-label fw-semibold">Send Response *</label>
                                        <textarea class="form-control" 
                                                  id="response_message" 
                                                  name="response_message" 
                                                  rows="4" 
                                                  placeholder="Type your response to the user..."
                                                  required></textarea>
                                    </div>
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="send_email" name="send_email" value="1" checked>
                                            <label class="form-check-label" for="send_email">
                                                Send as email to user
                                            </label>
                                        </div>
                                        <button type="submit" class="btn btn-success">
                                            <i class="fas fa-paper-plane me-1"></i> Send Response
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Internal Notes Form -->
                    <div class="card mt-3">
                        <div class="card-header bg-secondary text-white">
                            <h5 class="card-title mb-0">Add Internal Note</h5>
                        </div>
                        <div class="card-body">
                            <form action="{{ route('admin.contact-submissions.add-note', $submission->id) }}" method="POST">
                                @csrf
                                <div class="mb-3">
                                    <textarea class="form-control" 
                                              name="note" 
                                              rows="3" 
                                              placeholder="Add internal notes (not sent to user)..."
                                              required></textarea>
                                </div>
                                <button type="submit" class="btn btn-outline-secondary">
                                    <i class="fas fa-sticky-note me-1"></i> Add Note
                                </button>
                            </form>
                        </div>
                    </div>
                </div>

                <!-- Sidebar Panel -->
                <div class="col-lg-4">
                    <!-- Submission Info -->
                    <div class="card">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Submission Details</h5>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label fw-semibold">Status</label>
                                <div class="d-flex gap-2 align-items-center">
                                    <span class="badge {{ $submission->getStatusBadge() }}">
                                        {{ ucfirst($submission->status) }}
                                    </span>
                                    <div class="dropdown">
                                        <button class="btn btn-sm btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                            Change
                                        </button>
                                        <div class="dropdown-menu">
                                            <form action="{{ route('admin.contact-submissions.update-status', $submission->id) }}" method="POST">
                                                @csrf
                                                <button type="submit" name="status" value="new" class="dropdown-item">New</button>
                                                <button type="submit" name="status" value="in_progress" class="dropdown-item">In Progress</button>
                                                <button type="submit" name="status" value="resolved" class="dropdown-item">Resolved</button>
                                                <button type="submit" name="status" value="closed" class="dropdown-item">Closed</button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-semibold">Assigned To</label>
                                <form action="{{ route('admin.contact-submissions.assign', $submission->id) }}" method="POST" class="d-flex gap-2">
                                    @csrf
                                    <select name="assigned_to" class="form-select form-select-sm" onchange="this.form.submit()">
                                        <option value="">Unassigned</option>
                                        @foreach($adminUsers as $admin)
                                        <option value="{{ $admin->id }}" {{ $submission->assigned_to == $admin->id ? 'selected' : '' }}>
                                            {{ $admin->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                </form>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-semibold">Contact Information</label>
                                <p class="mb-1"><strong>Name:</strong> {{ $submission->name }}</p>
                                <p class="mb-1"><strong>Email:</strong> <a href="mailto:{{ $submission->email }}">{{ $submission->email }}</a></p>
                                @if($submission->phone)
                                <p class="mb-1"><strong>Phone:</strong> {{ $submission->phone }}</p>
                                @endif
                                <p class="mb-0"><strong>Newsletter:</strong> 
                                    @if($submission->newsletter)
                                        <span class="badge bg-success">Subscribed</span>
                                    @else
                                        <span class="badge bg-secondary">Not Subscribed</span>
                                    @endif
                                </p>
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-semibold">Timeline</label>
                                <p class="mb-1"><strong>Submitted:</strong> {{ $submission->created_at->format('M j, Y g:i A') }}</p>
                                @if($submission->read_at)
                                <p class="mb-1"><strong>First Read:</strong> {{ $submission->read_at->format('M j, Y g:i A') }}</p>
                                @endif
                                @if($submission->last_message_at)
                                <p class="mb-0"><strong>Last Activity:</strong> {{ $submission->last_message_at->format('M j, Y g:i A') }}</p>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Quick Actions -->
                    <div class="card mt-3">
                        <div class="card-header">
                            <h5 class="card-title mb-0">Quick Actions</h5>
                        </div>
                        <div class="card-body">
                            <div class="d-grid gap-2">
                                <a href="mailto:{{ $submission->email }}?subject=Re: {{ $submission->subject }}" 
                                   class="btn btn-outline-primary">
                                    <i class="fas fa-envelope me-1"></i> Reply via Email Client
                                </a>
                                
                                @if($submission->isUnread())
                                <form action="{{ route('admin.contact-submissions.mark-read', $submission->id) }}" method="POST">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn btn-outline-success w-100">
                                        <i class="fas fa-envelope-open me-1"></i> Mark as Read
                                    </button>
                                </form>
                                @else
                                <form action="{{ route('admin.contact-submissions.mark-unread', $submission->id) }}" method="POST">
                                    @csrf
                                    @method('PATCH')
                                    <button type="submit" class="btn btn-outline-warning w-100">
                                        <i class="fas fa-envelope me-1"></i> Mark as Unread
                                    </button>
                                </form>
                                @endif

                                <form action="{{ route('admin.contact-submissions.destroy', $submission->id) }}" 
                                      method="POST" 
                                      onsubmit="return confirm('Are you sure you want to delete this submission and all messages?')">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-outline-danger w-100">
                                        <i class="fas fa-trash me-1"></i> Delete Conversation
                                    </button>
                                </form>

                                <a href="{{ route('admin.contact-submissions.index') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-left me-1"></i> Back to List
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.message-bubble {
    position: relative;
}

.message-incoming .message-bubble {
    border-bottom-left-radius: 0;
}

.message-outgoing .message-bubble {
    border-bottom-right-radius: 0;
}

.conversation-messages {
    scroll-behavior: smooth;
}

.conversation-messages::-webkit-scrollbar {
    width: 6px;
}

.conversation-messages::-webkit-scrollbar-track {
    background: #f1f1f1;
}

.conversation-messages::-webkit-scrollbar-thumb {
    background: #c1c1c1;
    border-radius: 3px;
}

.conversation-messages::-webkit-scrollbar-thumb:hover {
    background: #a8a8a8;
}
</style>

<script>
// Auto-scroll to bottom of conversation
document.addEventListener('DOMContentLoaded', function() {
    const messagesContainer = document.querySelector('.conversation-messages');
    if (messagesContainer) {
        messagesContainer.scrollTop = messagesContainer.scrollHeight;
    }
});
</script>
@endsection