@extends('layouts.admin')

@section('title', 'Contact Submissions')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box">
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Contact Submissions</li>
                    </ol>
                </div>
                <h4 class="page-title">Contact Submissions</h4>
            </div>

            <div class="card">
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-sm-6">
                            <div class="d-flex gap-2">
                                <span class="badge bg-danger">Unread: {{ $unreadCount }}</span>
                                <span class="badge bg-secondary">Total: {{ $totalCount }}</span>
                            </div>
                        </div>
                        <div class="col-sm-6">
                            <div class="text-sm-end">
                                <div class="btn-group">
                                    <button type="button" class="btn btn-light dropdown-toggle" data-bs-toggle="dropdown">
                                        Bulk Actions
                                    </button>
                                    <div class="dropdown-menu">
                                        <button class="dropdown-item" onclick="bulkAction('mark-read')">
                                            <i class="fas fa-envelope-open text-success me-2"></i>Mark as Read
                                        </button>
                                        <button class="dropdown-item" onclick="bulkAction('mark-unread')">
                                            <i class="fas fa-envelope text-warning me-2"></i>Mark as Unread
                                        </button>
                                        <div class="dropdown-divider"></div>
                                        <button class="dropdown-item text-danger" onclick="bulkAction('delete')">
                                            <i class="fas fa-trash me-2"></i>Delete Selected
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    @endif

                    <div class="table-responsive">
                        <form id="bulkForm" action="{{ route('admin.contact-submissions.bulk-action') }}" method="POST">
                            @csrf
                            <input type="hidden" name="action" id="bulkAction">
                            
                            <table class="table table-centered table-striped dt-responsive nowrap w-100">
                                <thead class="table-light">
                                    <tr>
                                        <th style="width: 20px;">
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input" id="selectAll">
                                                <label class="form-check-label" for="selectAll"></label>
                                            </div>
                                        </th>
                                        <th>Status</th>
                                        <th>Name</th>
                                        <th>Email</th>
                                        <th>Subject</th>
                                        <th>Message Preview</th>
                                        <th>Submitted</th>
                                        <th style="width: 100px;">Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($submissions as $submission)
                                    <tr class="{{ $submission->isUnread() ? 'table-warning' : '' }}">
                                        <td>
                                            <div class="form-check">
                                                <input type="checkbox" class="form-check-input select-item" name="ids[]" value="{{ $submission->id }}">
                                            </div>
                                        </td>
                                        <td>
                                            @if($submission->isUnread())
                                                <span class="badge bg-danger">Unread</span>
                                            @else
                                                <span class="badge bg-success">Read</span>
                                            @endif
                                        </td>
                                        <td>
                                            <strong>{{ $submission->name }}</strong>
                                            @if($submission->phone)
                                                <br><small class="text-muted">{{ $submission->phone }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="mailto:{{ $submission->email }}">{{ $submission->email }}</a>
                                        </td>
                                        <td>{{ $submission->subject }}</td>
                                        <td>
                                            <span class="text-muted">{{ Str::limit($submission->message, 50) }}</span>
                                        </td>
                                        <td>{{ $submission->created_at->format('M j, Y g:i A') }}</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('admin.contact-submissions.show', $submission->id) }}" 
                                                   class="btn btn-sm btn-primary" 
                                                   data-bs-toggle="tooltip" 
                                                   title="View Details">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                
                                                @if($submission->isUnread())
                                                <form action="{{ route('admin.contact-submissions.mark-read', $submission->id) }}" 
                                                      method="POST" 
                                                      class="d-inline">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-success"
                                                            data-bs-toggle="tooltip" 
                                                            title="Mark as Read">
                                                        <i class="fas fa-envelope-open"></i>
                                                    </button>
                                                </form>
                                                @else
                                                <form action="{{ route('admin.contact-submissions.mark-unread', $submission->id) }}" 
                                                      method="POST" 
                                                      class="d-inline">
                                                    @csrf
                                                    @method('PATCH')
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-warning"
                                                            data-bs-toggle="tooltip" 
                                                            title="Mark as Unread">
                                                        <i class="fas fa-envelope"></i>
                                                    </button>
                                                </form>
                                                @endif
                                                
                                                <form action="{{ route('admin.contact-submissions.destroy', $submission->id) }}" 
                                                      method="POST" 
                                                      class="d-inline"
                                                      onsubmit="return confirm('Are you sure you want to delete this submission?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" 
                                                            class="btn btn-sm btn-danger"
                                                            data-bs-toggle="tooltip" 
                                                            title="Delete">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </form>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center mt-3">
                            {{ $submissions->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    // Select all functionality
    document.getElementById('selectAll').addEventListener('change', function() {
        const checkboxes = document.querySelectorAll('.select-item');
        checkboxes.forEach(checkbox => {
            checkbox.checked = this.checked;
        });
    });

    // Bulk action functionality
    function bulkAction(action) {
        const selectedItems = document.querySelectorAll('.select-item:checked');
        if (selectedItems.length === 0) {
            alert('Please select at least one submission to perform this action.');
            return;
        }

        if (action === 'delete' && !confirm('Are you sure you want to delete the selected submissions?')) {
            return;
        }

        document.getElementById('bulkAction').value = action;
        document.getElementById('bulkForm').submit();
    }

    // Initialize tooltips
    document.addEventListener('DOMContentLoaded', function() {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        var tooltipList = tooltipTriggerList.map(function(tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
</script>
@endpush