@extends('layouts.admin')

@section('title', 'Calculation Log Details')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-eye me-2"></i>Calculation Log Details
                        </h4>
                        <div class="btn-group">
                            <a href="{{ route('admin.calculation-logs.index') }}" class="btn btn-light btn-sm">
                                <i class="fas fa-arrow-left me-1"></i>Back to Logs
                            </a>
                            <a href="{{ route('admin.calculation-logs.recalculate', $calculationLog->id) }}" 
                               class="btn btn-warning btn-sm"
                               onclick="return confirm('Are you sure you want to recalculate this entry?')">
                                <i class="fas fa-redo me-1"></i>Recalculate
                            </a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Basic Information -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Calculation Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">Calculation ID</td>
                                                    <td>#{{ $calculationLog->id }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">HS Code</td>
                                                    <td>
                                                        <code>{{ $calculationLog->getInputValue('hs_code', 'N/A') }}</code>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Country of Origin</td>
                                                    <td>
                                                        <span class="badge bg-info">{{ $calculationLog->getInputValue('country_of_origin', 'N/A') }}</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">CIF Value</td>
                                                    <td class="text-success fw-bold">
                                                        {{ $calculationLog->getInputValue('currency', 'KES') }} 
                                                        {{ number_format($calculationLog->getInputValue('cif_value', 0), 2) }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Total Taxes</td>
                                                    <td class="text-danger fw-bold">
                                                        KES {{ number_format($calculationLog->total_payable, 2) }}
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Calculated By</td>
                                                    <td>
                                                        {{ $calculationLog->user->name ?? 'System' }}
                                                        <br>
                                                        <small class="text-muted">{{ $calculationLog->user->email ?? 'N/A' }}</small>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Calculation Date</td>
                                                    <td>{{ $calculationLog->created_at->format('M j, Y H:i:s') }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-cube me-2"></i>HS Code Information</h5>
                                </div>
                                <div class="card-body">
                                    @php
                                        $hsCodeDetails = $calculationLog->getResultValue('hs_code_details', []);
                                    @endphp
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">HS Code</td>
                                                    <td>{{ $hsCodeDetails['code'] ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Description</td>
                                                    <td>{{ $hsCodeDetails['description'] ?? 'N/A' }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Duty Type</td>
                                                    <td>
                                                        <span class="badge bg-info">{{ ucfirst($hsCodeDetails['duty_type'] ?? 'N/A') }}</span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Duty Value</td>
                                                    <td>
                                                        {{ $hsCodeDetails['duty_value'] ?? 'N/A' }}
                                                        @if(($hsCodeDetails['duty_type'] ?? '') === 'percentage')% @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Excise Applicable</td>
                                                    <td>
                                                        @if($hsCodeDetails['excise_applicable'] ?? false)
                                                            <span class="badge bg-warning">Yes</span>
                                                        @else
                                                            <span class="badge bg-secondary">No</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Sensitive Goods</td>
                                                    <td>
                                                        @if($hsCodeDetails['sensitive'] ?? false)
                                                            <span class="badge bg-danger">Yes</span>
                                                        @else
                                                            <span class="badge bg-secondary">No</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Tax Breakdown -->
                    <div class="card border-success mb-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0"><i class="fas fa-receipt me-2"></i>Tax Breakdown</h5>
                        </div>
                        <div class="card-body">
                            @php
                                $breakdown = $calculationLog->getResultValue('breakdown', []);
                                $taxBase = $calculationLog->getResultValue('tax_base', []);
                            @endphp
                            
                            <div class="row mb-4">
                                <div class="col-md-4 text-center">
                                    <h6 class="text-muted">CIF Value</h6>
                                    <h4 class="text-success">KES {{ number_format($taxBase['cif_value'] ?? 0, 2) }}</h4>
                                </div>
                                <div class="col-md-4 text-center">
                                    <h6 class="text-muted">Benchmark Applied</h6>
                                    <h4>
                                        @if($taxBase['benchmark_applied'] ?? false)
                                            <span class="text-warning">Yes</span>
                                            <br>
                                            <small>KES {{ number_format($taxBase['benchmark_value'] ?? 0, 2) }}</small>
                                        @else
                                            <span class="text-success">No</span>
                                        @endif
                                    </h4>
                                </div>
                                <div class="col-md-4 text-center">
                                    <h6 class="text-muted">Final Tax Base</h6>
                                    <h4 class="text-primary">KES {{ number_format($taxBase['final_tax_base'] ?? 0, 2) }}</h4>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table class="table table-bordered table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>Tax Type</th>
                                            <th>Amount (KES)</th>
                                            <th>Percentage of Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td class="fw-semibold">Import Duty</td>
                                            <td class="text-end fw-semibold">{{ number_format($breakdown['import_duty'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                {{ $calculationLog->total_payable > 0 ? number_format(($breakdown['import_duty'] ?? 0) / $calculationLog->total_payable * 100, 1) : 0 }}%
                                            </td>
                                        </tr>
                                        @if(($breakdown['excise_duty'] ?? 0) > 0)
                                        <tr>
                                            <td class="fw-semibold">Excise Duty</td>
                                            <td class="text-end fw-semibold">{{ number_format($breakdown['excise_duty'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                {{ $calculationLog->total_payable > 0 ? number_format(($breakdown['excise_duty'] ?? 0) / $calculationLog->total_payable * 100, 1) : 0 }}%
                                            </td>
                                        </tr>
                                        @endif
                                        <tr>
                                            <td class="fw-semibold">VAT</td>
                                            <td class="text-end fw-semibold">{{ number_format($breakdown['vat'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                {{ $calculationLog->total_payable > 0 ? number_format(($breakdown['vat'] ?? 0) / $calculationLog->total_payable * 100, 1) : 0 }}%
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">IDF</td>
                                            <td class="text-end fw-semibold">{{ number_format($breakdown['idf'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                {{ $calculationLog->total_payable > 0 ? number_format(($breakdown['idf'] ?? 0) / $calculationLog->total_payable * 100, 1) : 0 }}%
                                            </td>
                                        </tr>
                                        <tr>
                                            <td class="fw-semibold">RDL</td>
                                            <td class="text-end fw-semibold">{{ number_format($breakdown['rdl'] ?? 0, 2) }}</td>
                                            <td class="text-end">
                                                {{ $calculationLog->total_payable > 0 ? number_format(($breakdown['rdl'] ?? 0) / $calculationLog->total_payable * 100, 1) : 0 }}%
                                            </td>
                                        </tr>
                                    </tbody>
                                    <tfoot class="table-success">
                                        <tr>
                                            <td class="fw-bold fs-5">Total Taxes Payable</td>
                                            <td class="text-end fw-bold fs-5">KES {{ number_format($calculationLog->total_payable, 2) }}</td>
                                            <td class="text-end fw-bold fs-5">100%</td>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
                    </div>

                    <!-- Raw Data -->
                    <div class="card border-secondary">
                        <div class="card-header bg-secondary text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-code me-2"></i>Raw Data
                                <button class="btn btn-sm btn-light float-end" type="button" data-bs-toggle="collapse" data-bs-target="#rawData">
                                    Toggle
                                </button>
                            </h5>
                        </div>
                        <div class="collapse" id="rawData">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Input Data</h6>
                                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($calculationLog->input, JSON_PRETTY_PRINT) }}</code></pre>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>Result Data</h6>
                                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($calculationLog->result, JSON_PRETTY_PRINT) }}</code></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border-radius: 10px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

pre {
    font-size: 0.875em;
    max-height: 400px;
    overflow-y: auto;
}

.badge {
    font-size: 0.75em;
}
</style>
@endpush