@extends('layouts.admin')

@section('title', 'Benchmark Details')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4 class="mb-0">Benchmark Details</h4>
                <a href="{{ route('admin.benchmarks.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left me-1"></i>Back to List
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>HS Code:</strong> {{ $benchmark->hsCode->hs_code }}</p>
                        <p><strong>Description:</strong> {{ $benchmark->hsCode->description }}</p>
                        <p><strong>Minimum Type:</strong> <span class="badge bg-info text-capitalize">{{ $benchmark->min_type }}</span></p>
                        <p><strong>Minimum Value:</strong> {{ number_format($benchmark->min_value, 2) }} {{ $benchmark->currency }}</p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Status:</strong> 
                            @if($benchmark->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </p>
                        <p><strong>Effective From:</strong> {{ $benchmark->effective_from->format('M j, Y') }}</p>
                        <p><strong>Effective To:</strong> 
                            @if($benchmark->effective_to)
                                {{ $benchmark->effective_to->format('M j, Y') }}
                            @else
                                <span class="text-success">Ongoing</span>
                            @endif
                        </p>
                        <p><strong>Created:</strong> {{ $benchmark->created_at->format('M j, Y H:i') }}</p>
                        <p><strong>Last Updated:</strong> {{ $benchmark->updated_at->format('M j, Y H:i') }}</p>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="d-flex gap-2">
                    <a href="{{ route('admin.benchmarks.edit', $benchmark->id) }}" class="btn btn-warning">
                        <i class="fas fa-edit me-2"></i>Edit
                    </a>
                    <form action="{{ route('admin.benchmarks.destroy', $benchmark->id) }}" method="POST" class="d-inline">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure you want to delete this benchmark?')">
                            <i class="fas fa-trash me-2"></i>Delete
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection