@extends('layouts.admin')

@section('title', 'Benchmarks Management')

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="page-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2>Benchmarks Management</h2>
                <a href="{{ route('admin.benchmarks.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus me-2"></i>Add Benchmark
                </a>
            </div>
            <p class="text-muted">Manage minimum customs values for HS codes</p>
        </div>
    </div>
</div>

@include('partials.admin.alerts')

<!-- Search and Filters -->
<div class="card mb-4">
    <div class="card-body">
        <form action="{{ route('admin.benchmarks.index') }}" method="GET">
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <label for="search">Search HS Code or Description</label>
                        <input type="text" class="form-control" id="search" name="search" 
                               value="{{ request('search') }}" placeholder="Enter HS code or description...">
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="min_type">Minimum Type</label>
                        <select class="form-control" id="min_type" name="min_type">
                            <option value="">All Types</option>
                            <option value="cif" {{ request('min_type') == 'cif' ? 'selected' : '' }}>CIF Value</option>
                            <option value="per_kg" {{ request('min_type') == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                            <option value="per_container" {{ request('min_type') == 'per_container' ? 'selected' : '' }}>Per Container</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="currency">Currency</label>
                        <select class="form-control" id="currency" name="currency">
                            <option value="">All Currencies</option>
                            <option value="KES" {{ request('currency') == 'KES' ? 'selected' : '' }}>KES</option>
                            <option value="USD" {{ request('currency') == 'USD' ? 'selected' : '' }}>USD</option>
                            <option value="EUR" {{ request('currency') == 'EUR' ? 'selected' : '' }}>EUR</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <button type="submit" class="btn btn-primary w-100">
                            <i class="fas fa-search me-1"></i>Filter
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Benchmarks Table -->
<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h4 class="mb-0">Benchmarks</h4>
        <a href="{{ route('admin.benchmarks.create') }}" class="btn btn-primary btn-sm">
            <i class="fas fa-plus me-1"></i>Add New
        </a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>HS Code</th>
                        <th>Description</th>
                        <th>Minimum Type</th>
                        <th>Minimum Value</th>
                        <th>Currency</th>
                        <th>Effective Period</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($benchmarks as $benchmark)
                    <tr>
                        <td>
                            <strong>{{ $benchmark->hsCode->hs_code }}</strong>
                        </td>
                        <td>
                            <span title="{{ $benchmark->hsCode->description }}">
                                {{ Str::limit($benchmark->hsCode->description, 40) }}
                            </span>
                        </td>
                        <td>
                            <span class="badge bg-info text-capitalize">{{ $benchmark->min_type }}</span>
                        </td>
                        <td>
                            {{ number_format($benchmark->min_value, 2) }}
                        </td>
                        <td>
                            <span class="badge bg-secondary">{{ $benchmark->currency }}</span>
                        </td>
                        <td>
                            <small>
                                {{ $benchmark->effective_from->format('M j, Y') }}
                                @if($benchmark->effective_to)
                                    <br>to {{ $benchmark->effective_to->format('M j, Y') }}
                                @else
                                    <br><span class="text-success">Ongoing</span>
                                @endif
                            </small>
                        </td>
                        <td>
                            @if($benchmark->is_active)
                                <span class="badge bg-success">Active</span>
                            @else
                                <span class="badge bg-secondary">Inactive</span>
                            @endif
                        </td>
                        <td>
                            @include('partials.admin.tables.action-buttons', [
                                'viewUrl' => route('admin.benchmarks.show', $benchmark->id),
                                'editUrl' => route('admin.benchmarks.edit', $benchmark->id),
                                'deleteUrl' => route('admin.benchmarks.destroy', $benchmark->id)
                            ])
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        
        @if($benchmarks->hasPages())
            <div class="mt-3">
                {{ $benchmarks->links() }}
            </div>
        @endif
    </div>
</div>
@endsection