@extends('layouts.admin')

@section('title', 'Edit Benchmark')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Edit Benchmark</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.benchmarks.update', $benchmark->id) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hs_code_id" class="form-label">HS Code *</label>
                                <select class="form-control @error('hs_code_id') is-invalid @enderror" 
                                        id="hs_code_id" name="hs_code_id" required>
                                    <option value="">Select HS Code</option>
                                    @foreach($hsCodes as $hsCode)
                                        <option value="{{ $hsCode->id }}" {{ old('hs_code_id', $benchmark->hs_code_id) == $hsCode->id ? 'selected' : '' }}>
                                            {{ $hsCode->hs_code }} - {{ Str::limit($hsCode->description, 50) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('hs_code_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="min_type" class="form-label">Minimum Type *</label>
                                <select class="form-control @error('min_type') is-invalid @enderror" 
                                        id="min_type" name="min_type" required>
                                    <option value="">Select Type</option>
                                    <option value="cif" {{ old('min_type', $benchmark->min_type) == 'cif' ? 'selected' : '' }}>CIF Value</option>
                                    <option value="per_kg" {{ old('min_type', $benchmark->min_type) == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                                    <option value="per_container" {{ old('min_type', $benchmark->min_type) == 'per_container' ? 'selected' : '' }}>Per Container</option>
                                </select>
                                @error('min_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="min_value" class="form-label">Minimum Value *</label>
                                <input type="number" step="0.01" class="form-control @error('min_value') is-invalid @enderror" 
                                       id="min_value" name="min_value" value="{{ old('min_value', $benchmark->min_value) }}" required>
                                @error('min_value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="currency" class="form-label">Currency *</label>
                                <select class="form-control @error('currency') is-invalid @enderror" 
                                        id="currency" name="currency" required>
                                    <option value="">Select Currency</option>
                                    <option value="KES" {{ old('currency', $benchmark->currency) == 'KES' ? 'selected' : '' }}>KES - Kenyan Shilling</option>
                                    <option value="USD" {{ old('currency', $benchmark->currency) == 'USD' ? 'selected' : '' }}>USD - US Dollar</option>
                                    <option value="EUR" {{ old('currency', $benchmark->currency) == 'EUR' ? 'selected' : '' }}>EUR - Euro</option>
                                    <option value="GBP" {{ old('currency', $benchmark->currency) == 'GBP' ? 'selected' : '' }}>GBP - British Pound</option>
                                </select>
                                @error('currency')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_from" class="form-label">Effective From *</label>
                                <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                                       id="effective_from" name="effective_from" value="{{ old('effective_from', $benchmark->effective_from->format('Y-m-d')) }}" required>
                                @error('effective_from')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_to" class="form-label">Effective To</label>
                                <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                                       id="effective_to" name="effective_to" value="{{ old('effective_to', $benchmark->effective_to ? $benchmark->effective_to->format('Y-m-d') : '') }}">
                                @error('effective_to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Update Benchmark
                        </button>
                        <a href="{{ route('admin.benchmarks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection