@extends('layouts.admin')

@section('title', 'Create Benchmark')

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="mb-0">Create New Benchmark</h4>
            </div>
            <div class="card-body">
                <form action="{{ route('admin.benchmarks.store') }}" method="POST">
                    @csrf
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="hs_code_id" class="form-label">HS Code *</label>
                                <select class="form-control @error('hs_code_id') is-invalid @enderror" 
                                        id="hs_code_id" name="hs_code_id" required>
                                    <option value="">Select HS Code</option>
                                    @foreach($hsCodes as $hsCode)
                                        <option value="{{ $hsCode->id }}" {{ old('hs_code_id') == $hsCode->id ? 'selected' : '' }}>
                                            {{ $hsCode->hs_code }} - {{ Str::limit($hsCode->description, 50) }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('hs_code_id')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="min_type" class="form-label">Minimum Type *</label>
                                <select class="form-control @error('min_type') is-invalid @enderror" 
                                        id="min_type" name="min_type" required>
                                    <option value="">Select Type</option>
                                    <option value="cif" {{ old('min_type') == 'cif' ? 'selected' : '' }}>CIF Value</option>
                                    <option value="per_kg" {{ old('min_type') == 'per_kg' ? 'selected' : '' }}>Per KG</option>
                                    <option value="per_container" {{ old('min_type') == 'per_container' ? 'selected' : '' }}>Per Container</option>
                                </select>
                                @error('min_type')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="min_value" class="form-label">Minimum Value *</label>
                                <input type="number" step="0.01" class="form-control @error('min_value') is-invalid @enderror" 
                                       id="min_value" name="min_value" value="{{ old('min_value') }}" required>
                                @error('min_value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="currency" class="form-label">Currency *</label>
                                <select class="form-control @error('currency') is-invalid @enderror" 
                                        id="currency" name="currency" required>
                                    <option value="">Select Currency</option>
                                    <option value="KES" {{ old('currency') == 'KES' ? 'selected' : '' }}>KES - Kenyan Shilling</option>
                                    <option value="USD" {{ old('currency') == 'USD' ? 'selected' : '' }}>USD - US Dollar</option>
                                    <option value="EUR" {{ old('currency') == 'EUR' ? 'selected' : '' }}>EUR - Euro</option>
                                    <option value="GBP" {{ old('currency') == 'GBP' ? 'selected' : '' }}>GBP - British Pound</option>
                                </select>
                                @error('currency')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_from" class="form-label">Effective From *</label>
                                <input type="date" class="form-control @error('effective_from') is-invalid @enderror" 
                                       id="effective_from" name="effective_from" value="{{ old('effective_from') }}" required>
                                @error('effective_from')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="effective_to" class="form-label">Effective To</label>
                                <input type="date" class="form-control @error('effective_to') is-invalid @enderror" 
                                       id="effective_to" name="effective_to" value="{{ old('effective_to') }}">
                                @error('effective_to')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <small class="form-text text-muted">Leave empty if ongoing</small>
                            </div>
                        </div>
                    </div>

                    <div class="form-group mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Create Benchmark
                        </button>
                        <a href="{{ route('admin.benchmarks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times me-2"></i>Cancel
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">Benchmark Guidelines</h5>
            </div>
            <div class="card-body">
                <h6>Minimum Types</h6>
                <ul class="small">
                    <li><strong>CIF Value:</strong> Minimum customs value for the entire shipment</li>
                    <li><strong>Per KG:</strong> Minimum value per kilogram of goods</li>
                    <li><strong>Per Container:</strong> Minimum value per container</li>
                </ul>
                
                <h6>Purpose</h6>
                <p class="small">Benchmarks ensure fair valuation of imports and prevent under-invoicing.</p>
                
                <h6>Currency</h6>
                <p class="small">Values will be converted to KES using current exchange rates during calculation.</p>
            </div>
        </div>
    </div>
</div>
@endsection