@extends('layouts.admin')

@section('title', 'Audit Log Details')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-eye me-2"></i>Audit Log Details
                        </h4>
                        <a href="{{ route('admin.audit-logs') }}" class="btn btn-light btn-sm">
                            <i class="fas fa-arrow-left me-1"></i>Back to Logs
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm mb-4">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-info-circle me-2"></i>Basic Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">Log ID</td>
                                                    <td>#{{ $auditLog->id }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Action</td>
                                                    <td>
                                                        <span class="badge bg-{{ $auditLog->action == 'created' ? 'success' : ($auditLog->action == 'updated' ? 'warning' : 'danger') }}">
                                                            {{ ucfirst($auditLog->action) }}
                                                        </span>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Model Type</td>
                                                    <td>
                                                        <strong>{{ class_basename($auditLog->model_type) }}</strong>
                                                        <br>
                                                        <small class="text-muted">Full: {{ $auditLog->model_type }}</small>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Model ID</td>
                                                    <td>{{ $auditLog->model_id }}</td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Timestamp</td>
                                                    <td>{{ $auditLog->created_at->format('M j, Y H:i:s') }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card border-0 shadow-sm">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0"><i class="fas fa-user me-2"></i>User Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <tbody>
                                                <tr>
                                                    <td class="fw-semibold" width="40%">User</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            <div class="flex-shrink-0">
                                                                <i class="fas fa-user-circle fa-2x text-muted"></i>
                                                            </div>
                                                            <div class="flex-grow-1 ms-3">
                                                                <div class="fw-semibold">{{ $auditLog->user->name ?? 'System' }}</div>
                                                                <small class="text-muted">{{ $auditLog->user->email ?? 'N/A' }}</small>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">IP Address</td>
                                                    <td>
                                                        <code>{{ $auditLog->ip_address ?? 'N/A' }}</code>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">User Agent</td>
                                                    <td>
                                                        <small class="text-muted">{{ $auditLog->user_agent ?? 'N/A' }}</small>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td class="fw-semibold">Remarks</td>
                                                    <td>{{ $auditLog->remarks ?? '—' }}</td>
                                                </tr>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Changes Comparison -->
                    @if($auditLog->action == 'updated' && $auditLog->old_values && $auditLog->new_values)
                    <div class="card border-warning mt-4">
                        <div class="card-header bg-warning text-dark">
                            <h5 class="mb-0"><i class="fas fa-exchange-alt me-2"></i>Changes Made</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="30%">Field</th>
                                            <th width="35%">Old Value</th>
                                            <th width="35%">New Value</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($auditLog->new_values as $field => $newValue)
                                        <tr>
                                            <td class="fw-semibold">
                                                {{ ucfirst(str_replace('_', ' ', $field)) }}
                                            </td>
                                            <td>
                                                @if(isset($auditLog->old_values[$field]))
                                                    <span class="text-danger">
                                                        {{ is_array($auditLog->old_values[$field]) ? json_encode($auditLog->old_values[$field]) : $auditLog->old_values[$field] }}
                                                    </span>
                                                @else
                                                    <span class="text-muted">—</span>
                                                @endif
                                            </td>
                                            <td>
                                                <span class="text-success">
                                                    {{ is_array($newValue) ? json_encode($newValue) : $newValue }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @elseif($auditLog->action == 'created' && $auditLog->new_values)
                    <div class="card border-success mt-4">
                        <div class="card-header bg-success text-white">
                            <h5 class="mb-0"><i class="fas fa-plus me-2"></i>Created Data</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="40%">Field</th>
                                            <th width="60%">Value</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($auditLog->new_values as $field => $value)
                                        <tr>
                                            <td class="fw-semibold">
                                                {{ ucfirst(str_replace('_', ' ', $field)) }}
                                            </td>
                                            <td>
                                                <span class="text-success">
                                                    {{ is_array($value) ? json_encode($value) : $value }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @elseif($auditLog->action == 'deleted' && $auditLog->old_values)
                    <div class="card border-danger mt-4">
                        <div class="card-header bg-danger text-white">
                            <h5 class="mb-0"><i class="fas fa-trash me-2"></i>Deleted Data</h5>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-bordered">
                                    <thead class="table-light">
                                        <tr>
                                            <th width="40%">Field</th>
                                            <th width="60%">Value</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($auditLog->old_values as $field => $value)
                                        <tr>
                                            <td class="fw-semibold">
                                                {{ ucfirst(str_replace('_', ' ', $field)) }}
                                            </td>
                                            <td>
                                                <span class="text-danger">
                                                    {{ is_array($value) ? json_encode($value) : $value }}
                                                </span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Raw Data (for debugging) -->
                    <div class="card border-secondary mt-4">
                        <div class="card-header bg-secondary text-white">
                            <h5 class="mb-0">
                                <i class="fas fa-code me-2"></i>Raw Data
                                <button class="btn btn-sm btn-light float-end" type="button" data-bs-toggle="collapse" data-bs-target="#rawData">
                                    Toggle
                                </button>
                            </h5>
                        </div>
                        <div class="collapse" id="rawData">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>Old Values</h6>
                                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($auditLog->old_values, JSON_PRETTY_PRINT) }}</code></pre>
                                    </div>
                                    <div class="col-md-6">
                                        <h6>New Values</h6>
                                        <pre class="bg-light p-3 rounded"><code>{{ json_encode($auditLog->new_values, JSON_PRETTY_PRINT) }}</code></pre>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border-radius: 10px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

pre {
    font-size: 0.875em;
    max-height: 300px;
    overflow-y: auto;
}

.badge {
    font-size: 0.75em;
}
</style>
@endpush