@extends('layouts.admin')

@section('title', 'Audit Logs')

@section('content')
<div class="container-fluid px-4">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <div class="d-flex justify-content-between align-items-center">
                        <h4 class="mb-0">
                            <i class="fas fa-clipboard-list me-2"></i>Audit Logs
                        </h4>
                        <div class="btn-group">
                            <button type="button" class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#clearLogsModal">
                                <i class="fas fa-broom me-1"></i>Clear Logs
                            </button>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Statistics -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="card border-primary text-center">
                                <div class="card-body py-3">
                                    <h3 class="text-primary mb-0">{{ number_format($stats['totalLogs']) }}</h3>
                                    <small class="text-muted">Total Logs</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-success text-center">
                                <div class="card-body py-3">
                                    <h3 class="text-success mb-0">{{ number_format($stats['todayLogs']) }}</h3>
                                    <small class="text-muted">Today's Logs</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-info text-center">
                                <div class="card-body py-3">
                                    <h3 class="text-info mb-0">{{ number_format($stats['uniqueUsers']) }}</h3>
                                    <small class="text-muted">Active Users</small>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="card border-warning text-center">
                                <div class="card-body py-3">
                                    <h3 class="text-warning mb-0">{{ number_format($stats['uniqueModels']) }}</h3>
                                    <small class="text-muted">Model Types</small>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filters -->
                    <form action="{{ route('admin.audit-logs') }}" method="GET" class="mb-4">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="search" class="form-label">Search</label>
                                    <input type="text" class="form-control" id="search" name="search" 
                                           value="{{ request('search') }}" placeholder="Search logs...">
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="action" class="form-label">Action</label>
                                    <select class="form-control" id="action" name="action">
                                        <option value="">All Actions</option>
                                        @foreach($actions as $action)
                                            <option value="{{ $action }}" 
                                                {{ request('action') == $action ? 'selected' : '' }}>
                                                {{ ucfirst($action) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="model_type" class="form-label">Model Type</label>
                                    <select class="form-control" id="model_type" name="model_type">
                                        <option value="">All Models</option>
                                        @foreach($modelTypes as $modelType)
                                            <option value="{{ $modelType }}" 
                                                {{ request('model_type') == $modelType ? 'selected' : '' }}>
                                                {{ class_basename($modelType) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="form-group">
                                    <label for="user_id" class="form-label">User</label>
                                    <select class="form-control" id="user_id" name="user_id">
                                        <option value="">All Users</option>
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" 
                                                {{ request('user_id') == $user->id ? 'selected' : '' }}>
                                                {{ $user->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="row">
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="date_from" class="form-label">From Date</label>
                                            <input type="date" class="form-control" id="date_from" name="date_from" 
                                                   value="{{ request('date_from') }}">
                                        </div>
                                    </div>
                                    <div class="col-6">
                                        <div class="form-group">
                                            <label for="date_to" class="form-label">To Date</label>
                                            <input type="date" class="form-control" id="date_to" name="date_to" 
                                                   value="{{ request('date_to') }}">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row mt-2">
                            <div class="col-12">
                                <button type="submit" class="btn btn-primary">Apply Filters</button>
                                <a href="{{ route('admin.audit-logs') }}" class="btn btn-secondary">Clear Filters</a>
                            </div>
                        </div>
                    </form>

                    @if($auditLogs->count())
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>ID</th>
                                    <th>Action</th>
                                    <th>Model</th>
                                    <th>User</th>
                                    <th>Changes</th>
                                    <th>IP Address</th>
                                    <th>Timestamp</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($auditLogs as $log)
                                <tr>
                                    <td>
                                        <small class="text-muted">#{{ $log->id }}</small>
                                    </td>
                                    <td>
                                        <span class="badge bg-{{ $log->action == 'created' ? 'success' : ($log->action == 'updated' ? 'warning' : 'danger') }}">
                                            {{ ucfirst($log->action) }}
                                        </span>
                                    </td>
                                    <td>
                                        <div>
                                            <strong>{{ class_basename($log->model_type) }}</strong>
                                            @if($log->model)
                                                <br>
                                                <small class="text-muted">ID: {{ $log->model_id }}</small>
                                            @endif
                                        </div>
                                    </td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="flex-shrink-0">
                                                <i class="fas fa-user-circle text-muted"></i>
                                            </div>
                                            <div class="flex-grow-1 ms-2">
                                                <div class="fw-semibold">{{ $log->user->name ?? 'System' }}</div>
                                                <small class="text-muted">{{ $log->user->email ?? 'N/A' }}</small>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        @if($log->action == 'updated' && $log->old_values && $log->new_values)
                                            <span class="badge bg-info">
                                                {{ count($log->new_values) }} changes
                                            </span>
                                        @elseif($log->action == 'created')
                                            <span class="badge bg-success">New record</span>
                                        @elseif($log->action == 'deleted')
                                            <span class="badge bg-danger">Deleted</span>
                                        @else
                                            <span class="text-muted">—</span>
                                        @endif
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $log->ip_address ?? 'N/A' }}</small>
                                    </td>
                                    <td>
                                        <small class="text-muted">{{ $log->created_at->format('M j, Y H:i') }}</small>
                                    </td>
                                    <td>
                                        <div class="btn-group btn-group-sm">
                                            <a href="{{ route('admin.audit-logs.show', $log->id) }}" 
                                               class="btn btn-info" title="View Details">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <div class="text-muted">
                            Showing {{ $auditLogs->firstItem() }} to {{ $auditLogs->lastItem() }} of {{ $auditLogs->total() }} audit logs
                        </div>
                        {{ $auditLogs->links() }}
                    </div>
                    @else
                    <div class="text-center py-5">
                        <i class="fas fa-clipboard-list fa-3x text-muted mb-3"></i>
                        <h5 class="text-muted">No Audit Logs Found</h5>
                        <p class="text-muted mb-4">
                            @if(request()->anyFilled(['search', 'action', 'model_type', 'user_id', 'date_from', 'date_to']))
                                No audit logs match your filter criteria.
                            @else
                                No audit logs have been recorded yet.
                            @endif
                        </p>
                        @if(request()->anyFilled(['search', 'action', 'model_type', 'user_id', 'date_from', 'date_to']))
                            <a href="{{ route('admin.audit-logs') }}" class="btn btn-secondary">Clear Filters</a>
                        @endif
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Clear Logs Modal -->
<div class="modal fade" id="clearLogsModal" tabindex="-1" aria-labelledby="clearLogsModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="clearLogsModalLabel">
                    <i class="fas fa-broom me-2"></i>Clear Audit Logs
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('admin.audit-logs.clear') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>
                        <strong>Warning:</strong> This action cannot be undone. Audit logs will be permanently deleted.
                    </div>
                    
                    <div class="form-group mb-3">
                        <label for="older_than" class="form-label">Delete logs older than:</label>
                        <select class="form-control" id="older_than" name="older_than" required>
                            <option value="30">30 days</option>
                            <option value="60">60 days</option>
                            <option value="90">90 days</option>
                            <option value="180">180 days</option>
                            <option value="365">1 year</option>
                        </select>
                    </div>
                    
                    <div class="form-group mb-3">
                        <label for="confirmation" class="form-label">Type "DELETE_LOGS" to confirm:</label>
                        <input type="text" class="form-control" id="confirmation" name="confirmation" 
                               placeholder="DELETE_LOGS" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-danger">Clear Logs</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('styles')
<style>
.card {
    border-radius: 10px;
}

.table th {
    border-top: none;
    font-weight: 600;
}

.btn {
    border-radius: 6px;
}

.badge {
    font-size: 0.75em;
}
</style>
@endpush