<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Faq;

class FaqSeeder extends Seeder
{
    public function run(): void
    {
        $faqs = [
            [
                'question' => 'How accurate are the tax calculations?',
                'answer' => 'Our calculations are based on current Kenyan tax regulations and are regularly updated. However, final amounts may vary based on actual customs assessment and specific circumstances.',
                'order' => 1,
                'category' => 'General'
            ],
            [
                'question' => 'Do you provide customs clearance services?',
                'answer' => 'We specialize in tax calculation and estimation. For actual customs clearance services, we recommend contacting licensed customs agents.',
                'order' => 2,
                'category' => 'Services'
            ],
            [
                'question' => 'How often are exchange rates updated?',
                'answer' => 'Exchange rates are updated daily based on the latest Central Bank of Kenya rates. You can also check our admin panel for the most current rates.',
                'order' => 3,
                'category' => 'Technical'
            ],
            [
                'question' => 'What information do I need for tax calculation?',
                'answer' => 'You need the product description, HS code, country of origin, product value, and quantity. Our system will guide you through the process.',
                'order' => 4,
                'category' => 'Calculation'
            ],
            [
                'question' => 'Can I save my calculation history?',
                'answer' => 'Yes, registered users can save their calculation history for future reference and comparison.',
                'order' => 5,
                'category' => 'Account'
            ]
        ];

        foreach ($faqs as $faq) {
            Faq::create($faq);
        }
    }
}