<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('contact_submissions', function (Blueprint $table) {
            $table->enum('status', ['new', 'in_progress', 'resolved', 'closed'])->default('new')->after('read_at');
            $table->integer('message_count')->default(1)->after('status'); // Count includes original submission
            $table->timestamp('last_message_at')->nullable()->after('message_count');
            $table->foreignId('assigned_to')->nullable()->constrained('users')->onDelete('set null')->after('last_message_at');
        });
    }

    public function down(): void
    {
        Schema::table('contact_submissions', function (Blueprint $table) {
            $table->dropColumn(['status', 'message_count', 'last_message_at', 'assigned_to']);
        });
    }
};