<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('contact_messages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('contact_submission_id')->constrained()->onDelete('cascade');
            $table->enum('type', ['incoming', 'outgoing']);
            $table->text('message');
            $table->foreignId('user_id')->nullable()->constrained()->onDelete('set null'); // For admin responses
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contact_messages');
    }
};