<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique();
            $table->text('value')->nullable();
            $table->string('type')->default('string');
            $table->string('category')->default('general');
            $table->text('description')->nullable();
            $table->timestamps();
        });

        // Insert default settings
        $this->insertDefaultSettings();
    }

    private function insertDefaultSettings()
    {
        $defaultSettings = [
            // General Settings
            [
                'key' => 'company_name',
                'value' => 'Kenya Import Tax Simulator',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Company name displayed throughout the application',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'app_logo',
                'value' => null,
                'type' => 'file',
                'category' => 'general',
                'description' => 'Application logo displayed in header and emails',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'default_currency',
                'value' => 'KES',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Default currency for calculations and displays',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'default_timezone',
                'value' => 'Africa/Nairobi',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Default timezone for the application',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'date_format',
                'value' => 'd/m/Y',
                'type' => 'string',
                'category' => 'general',
                'description' => 'Default date format throughout the application',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Contact Information
            [
                'key' => 'contact_email',
                'value' => 'support@taxsimulator.co.ke',
                'type' => 'string',
                'category' => 'contact',
                'description' => 'Primary contact email address for support',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'whatsapp_number',
                'value' => '254700000000',
                'type' => 'string',
                'category' => 'contact',
                'description' => 'WhatsApp business number for customer support',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'support_phone',
                'value' => '+254 700 000 000',
                'type' => 'string',
                'category' => 'contact',
                'description' => 'Support phone number',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'office_address',
                'value' => 'Nairobi, Kenya',
                'type' => 'text',
                'category' => 'contact',
                'description' => 'Physical office address',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Tax Configuration
            [
                'key' => 'default_tax_version',
                'value' => '2024',
                'type' => 'string',
                'category' => 'tax',
                'description' => 'Default tax version for calculations',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'calculation_precision',
                'value' => '2',
                'type' => 'integer',
                'category' => 'tax',
                'description' => 'Number of decimal places for tax calculations',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'auto_update_exchange_rates',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'tax',
                'description' => 'Automatically update exchange rates daily',
                'created_at' => now(),
                'updated_at' => now(),
            ],

            // Notifications
            [
                'key' => 'admin_email_notifications',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'notifications',
                'description' => 'Send email notifications to administrators',
                'created_at' => now(),
                'updated_at' => now(),
            ],
            [
                'key' => 'user_email_notifications',
                'value' => '1',
                'type' => 'boolean',
                'category' => 'notifications',
                'description' => 'Send email notifications to users',
                'created_at' => now(),
                'updated_at' => now(),
            ],
        ];

        foreach ($defaultSettings as $setting) {
            DB::table('settings')->updateOrInsert(
                ['key' => $setting['key']],
                $setting
            );
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};