<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('calculation_logs', function (Blueprint $table) {
            $table->id();
            $table->json('input');
            $table->json('result');
            $table->json('rule_version_ids')->nullable();
            $table->json('calculation_steps')->nullable();
            $table->decimal('total_payable', 18, 2);
            $table->foreignId('calculated_by')->nullable()->constrained('users');
            $table->string('session_id')->nullable();
            $table->string('ip_address')->nullable();
            $table->string('user_agent')->nullable();
            $table->timestamps();
            
            // Use custom shorter index names
            $table->index(['calculated_by'], 'calculated_by_idx');
            $table->index(['session_id'], 'session_id_idx');
            $table->index(['created_at'], 'created_at_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('calculation_logs');
    }
};