<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tax_versions', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description')->nullable();
            $table->json('rules_snapshot')->nullable();
            $table->boolean('is_active')->default(false);
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->foreignId('created_by')->constrained('users');
            $table->timestamps();
            $table->softDeletes();
            
            // Use custom shorter index names
            $table->index(['is_active'], 'is_active_idx');
            $table->index(['effective_from', 'effective_to'], 'effective_period_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tax_versions');
    }
};