<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('exchange_rates', function (Blueprint $table) {
            $table->id();
            $table->string('base_currency', 3)->default('KES');
            $table->string('target_currency', 3);
            $table->decimal('rate', 18, 6);
            $table->date('effective_date');
            $table->boolean('is_active')->default(true);
            $table->timestamps();
            $table->softDeletes();
            
            // Use custom shorter index names
            $table->unique(['base_currency', 'target_currency', 'effective_date'], 'exchange_rate_unique');
            $table->index(['base_currency', 'target_currency'], 'currency_pair_idx');
            $table->index(['effective_date'], 'effective_date_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('exchange_rates');
    }
};