<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('country_duty_overrides', function (Blueprint $table) {
            $table->id();
            $table->string('country_code', 3);
            $table->foreignId('hs_code_id')->constrained()->onDelete('cascade');
            $table->enum('duty_type', ['percentage', 'flat', 'per_kg', 'per_container']);
            $table->decimal('duty_value', 18, 4);
            $table->text('remarks')->nullable();
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            // Use custom shorter index names
            $table->unique(['country_code', 'hs_code_id', 'effective_from'], 'country_override_unique');
            $table->index(['country_code'], 'country_code_idx');
            $table->index(['hs_code_id'], 'hs_code_id_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('country_duty_overrides');
    }
};