<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('benchmarks', function (Blueprint $table) {
            $table->id();
            $table->foreignId('hs_code_id')->constrained()->onDelete('cascade');
            $table->enum('min_type', ['cif', 'per_kg', 'per_container']);
            $table->decimal('min_value', 18, 2);
            $table->string('currency', 3)->default('KES');
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['hs_code_id', 'effective_from', 'effective_to']);
            $table->index(['min_type']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('benchmarks');
    }
};