<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tax_configs', function (Blueprint $table) {
            $table->id();
            $table->string('tax_name'); // VAT, IDF, RDL, Excise
            $table->enum('rate_type', ['percentage', 'flat']);
            $table->decimal('rate', 18, 4);
            $table->decimal('min_amount', 18, 2)->nullable();
            $table->boolean('active')->default(true);
            $table->date('effective_from');
            $table->date('effective_to')->nullable();
            $table->text('remarks')->nullable();
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['tax_name', 'active']);
            $table->index(['effective_from', 'effective_to']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tax_configs');
    }
};