<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('hs_codes', function (Blueprint $table) {
            $table->id();
            $table->string('hs_code', 20)->unique();
            $table->string('description');
            $table->enum('default_duty_type', ['percentage', 'flat', 'per_kg', 'per_container']);
            $table->decimal('default_duty_value', 18, 4);
            $table->boolean('excise_applicable')->default(false);
            $table->json('excise_formula')->nullable();
            $table->boolean('sensitive')->default(false);
            $table->timestamps();
            $table->softDeletes();
            
            $table->index(['hs_code']);
            $table->index(['default_duty_type']);
            $table->index(['excise_applicable']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('hs_codes');
    }
};