<?php

namespace App\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    public function boot()
    {
        // Permission check directive
        Blade::if('can', function ($permission) {
            return auth()->check() && auth()->user()->hasPermission($permission);
        });

        // First admin check directive
        Blade::if('firstAdmin', function () {
            return auth()->check() && auth()->user()->isFirstAdmin();
        });
    }
}