<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TaxConfig extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'tax_name',
        'rate_type',
        'rate',
        'min_amount',
        'active',
        'effective_from',
        'effective_to',
        'remarks',
    ];

    protected $casts = [
        'rate' => 'decimal:4',
        'min_amount' => 'decimal:2',
        'active' => 'boolean',
        'effective_from' => 'date',
        'effective_to' => 'date',
    ];

    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeCurrent($query)
    {
        return $query->where('effective_from', '<=', now())
            ->where(function($q) {
                $q->whereNull('effective_to')
                  ->orWhere('effective_to', '>=', now());
            });
    }

    public function scopeForTax($query, $taxName)
    {
        return $query->where('tax_name', $taxName);
    }

    public function scopeEffectiveOn($query, $date = null)
    {
        $date = $date ?: now();
        return $query->where('effective_from', '<=', $date)
            ->where(function($q) use ($date) {
                $q->whereNull('effective_to')
                  ->orWhere('effective_to', '>=', $date);
            });
    }

    public function getIsCurrentAttribute(): bool
    {
        return $this->effective_from <= now() && 
               (!$this->effective_to || $this->effective_to >= now());
    }
}