<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    use HasFactory;

    protected $fillable = ['key', 'value', 'type', 'category', 'description'];

    public $timestamps = true;

    public static function get($key, $default = null)
    {
        $setting = static::where('key', $key)->first();
        return $setting ? $setting->value : $default;
    }

    public static function set($key, $value)
    {
        return static::updateOrCreate(
            ['key' => $key],
            ['value' => $value]
        );
    }

    /**
     * Get all settings grouped by category
     */
    public static function getGrouped()
    {
        return static::all()->groupBy('category')->map(function ($settings) {
            return $settings->pluck('value', 'key');
        });
    }

    /**
     * Get settings for a specific category
     */
    public static function getByCategory($category)
    {
        return static::where('category', $category)->pluck('value', 'key')->toArray();
    }
}