<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExchangeRate extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'base_currency',
        'target_currency',
        'rate',
        'effective_date',
        'is_active',
    ];

    protected $casts = [
        'rate' => 'decimal:6',
        'effective_date' => 'date',
        'is_active' => 'boolean',
    ];

    public function baseCurrency()
    {
        return $this->belongsTo(Currency::class, 'base_currency', 'code');
    }

    public function targetCurrency()
    {
        return $this->belongsTo(Currency::class, 'target_currency', 'code');
    }

    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeCurrent($query)
    {
        return $query->where('effective_date', '<=', now())
            ->where('is_active', true)
            ->orderBy('effective_date', 'desc');
    }

    public function scopeForCurrency($query, $currency)
    {
        return $query->where('target_currency', $currency)
            ->where('base_currency', 'KES');
    }

    public function scopeEffectiveOn($query, $date = null)
    {
        $date = $date ?: now();
        return $query->where('effective_date', '<=', $date)
            ->where('is_active', true)
            ->orderBy('effective_date', 'desc');
    }
}