<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Country extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'name',
        'region',
        'active',
    ];

    protected $casts = [
        'active' => 'boolean',
    ];

    public function dutyOverrides()
    {
        return $this->hasMany(CountryDutyOverride::class, 'country_code', 'code');
    }

    public function scopeActive($query)
    {
        return $query->where('active', true);
    }

    public function scopeByRegion($query, $region)
    {
        return $query->where('region', $region);
    }

    public function scopeEac($query)
    {
        return $query->where('region', 'EAC');
    }

    public function scopeComesa($query)
    {
        return $query->where('region', 'COMESA');
    }

    public function getHasTradeAgreementAttribute(): bool
    {
        return in_array($this->region, ['EAC', 'COMESA']);
    }
}