<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContactMessage extends Model
{
    use HasFactory;

    protected $fillable = [
        'contact_submission_id',
        'type',
        'message',
        'user_id',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Relationships
    public function submission()
    {
        return $this->belongsTo(ContactSubmission::class, 'contact_submission_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeIncoming($query)
    {
        return $query->where('type', 'incoming');
    }

    public function scopeOutgoing($query)
    {
        return $query->where('type', 'outgoing');
    }

    // Helpers
    public function isIncoming()
    {
        return $this->type === 'incoming';
    }

    public function isOutgoing()
    {
        return $this->type === 'outgoing';
    }

    public function getSenderName()
    {
        if ($this->isOutgoing() && $this->user) {
            return $this->user->name . ' (Admin)';
        }
        
        return $this->submission->name;
    }

    public function getSenderEmail()
    {
        if ($this->isOutgoing() && $this->user) {
            return $this->user->email;
        }
        
        return $this->submission->email;
    }
}