<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CalculationLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'input',
        'result',
        'rule_version_ids',
        'calculation_steps',
        'total_payable',
        'calculated_by',
        'session_id',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'input' => 'array',
        'result' => 'array',
        'rule_version_ids' => 'array',
        'calculation_steps' => 'array',
        'total_payable' => 'decimal:2',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'calculated_by');
    }

    public function scopeToday($query)
    {
        return $query->whereDate('created_at', today());
    }

    public function scopeThisWeek($query)
    {
        return $query->whereBetween('created_at', [now()->startOfWeek(), now()->endOfWeek()]);
    }

    public function scopeThisMonth($query)
    {
        return $query->whereBetween('created_at', [now()->startOfMonth(), now()->endOfMonth()]);
    }

    public function getTaxBreakdownAttribute(): array
    {
        return $this->result['breakdown'] ?? [];
    }

    public function getInputValue($key, $default = null)
    {
        return data_get($this->input, $key, $default);
    }

    public function getResultValue($key, $default = null)
    {
        return data_get($this->result, $key, $default);
    }
}