<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Benchmark extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'hs_code_id',
        'min_type',
        'min_value',
        'currency',
        'effective_from',
        'effective_to',
    ];

    protected $casts = [
        'min_value' => 'decimal:2',
        'effective_from' => 'date',
        'effective_to' => 'date',
    ];

    public function hsCode()
    {
        return $this->belongsTo(HsCode::class);
    }

    public function scopeActive($query)
    {
        return $query->where('effective_from', '<=', now())
            ->where(function($q) {
                $q->whereNull('effective_to')
                  ->orWhere('effective_to', '>=', now());
            });
    }

    public function scopeForHsCode($query, $hsCodeId)
    {
        return $query->where('hs_code_id', $hsCodeId);
    }

    public function scopeEffectiveOn($query, $date = null)
    {
        $date = $date ?: now();
        return $query->where('effective_from', '<=', $date)
            ->where(function($q) use ($date) {
                $q->whereNull('effective_to')
                  ->orWhere('effective_to', '>=', $date);
            });
    }

    public function getIsActiveAttribute(): bool
    {
        return $this->effective_from <= now() && 
               (!$this->effective_to || $this->effective_to >= now());
    }
}