<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdminRole extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'slug',
        'permissions',
        'description',
        'is_active'
    ];

    protected $casts = [
        'permissions' => 'array',
        'is_active' => 'boolean'
    ];

    public function users()
    {
        return $this->hasMany(User::class, 'role_id'); // Specify the foreign key
    }

    public function getPermissionListAttribute()
    {
        return $this->permissions ?? [];
    }

    public function hasPermission($permission)
    {
        if (in_array('*', $this->permissions ?? [])) {
            return true;
        }

        foreach ($this->permissions as $perm) {
            if ($perm === $permission) {
                return true;
            }
            
            // Check for wildcard permissions
            if (str_ends_with($perm, '.*')) {
                $prefix = str_replace('.*', '', $perm);
                if (str_starts_with($permission, $prefix)) {
                    return true;
                }
            }
        }

        return false;
    }
}