<?php

namespace App\Mail;

use App\Models\ContactSubmission;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class ContactConfirmation extends Mailable
{
    use Queueable, SerializesModels;

    public $submission;
    public $settings;

    public function __construct(ContactSubmission $submission)
    {
        $this->submission = $submission;
        $this->settings = [
            'company_name' => 'Kenya Import Tax Simulator',
            'support_email' => \App\Models\Setting::get('contact_email', 'support@taxsimulator.co.ke'),
            'whatsapp_number' => \App\Models\Setting::get('whatsapp_number', '+254700000000'),
        ];
    }

    public function build()
    {
        return $this->subject('Contact Form Submission Confirmation - Kenya Import Tax Simulator')
                    ->markdown('emails.contact-confirmation')
                    ->with([
                        'submission' => $this->submission,
                        'settings' => $this->settings,
                    ]);
    }
}