<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;

class HsCodeRequest extends FormRequest
{
    public function authorize(): bool
    {
        return auth()->check() && auth()->user()->is_admin;
    }

    public function rules(): array
    {
        return [
            'hs_code' => 'required|string|max:20|unique:hs_codes,hs_code,' . $this->route('hs_code'),
            'description' => 'required|string|max:500',
            'default_duty_type' => 'required|in:percentage,flat,per_kg,per_container',
            'default_duty_value' => 'required|numeric|min:0',
            'excise_applicable' => 'boolean',
            'excise_formula' => 'nullable|json',
            'sensitive' => 'boolean',
        ];
    }

    public function messages(): array
    {
        return [
            'hs_code.unique' => 'This HS code already exists in the system.',
            'excise_formula.json' => 'Excise formula must be valid JSON format.',
        ];
    }
}