<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminPermission
{
    public function handle(Request $request, Closure $next, $permission = null): Response
    {
        $user = auth()->user();

        if (!$user) {
            return redirect()->route('login');
        }

        // First admin bypasses all permission checks
        if ($user->isFirstAdmin()) {
            return $next($request);
        }

        // Check if user is admin and active
        if (!$user->is_admin || !$user->is_active) {
            abort(403, 'Admin access required.');
        }

        // If specific permission is required, check it
        if ($permission && !$user->hasPermission($permission)) {
            abort(403, "Required permission: {$permission}");
        }

        return $next($request);
    }
}