<?php

namespace App\Http\Controllers\Admin;

use App\Models\HsCode;
use App\Models\CountryDutyOverride;
use App\Models\CalculationLog;
use App\Models\TaxVersion;
use App\Models\ExchangeRate;
use App\Models\TaxConfig;
use App\Models\Country;
use App\Models\Benchmark;
use Illuminate\Http\Request;

class DashboardController extends BaseController  // Changed from Controller to BaseController
{
    public function index()
    {
        // Core statistics
        $stats = [
            'total_hs_codes' => HsCode::count(),
            'total_country_overrides' => CountryDutyOverride::active()->count(),
            'total_calculations' => CalculationLog::count(),
            'today_calculations' => CalculationLog::whereDate('created_at', today())->count(),
            'active_tax_rules' => TaxConfig::active()->count(),
            'total_countries' => Country::active()->count(),
            'total_benchmarks' => Benchmark::active()->count(),
            'total_revenue' => CalculationLog::whereDate('created_at', today())->sum('total_payable'),
        ];

        // Recent activity
        $recentCalculations = CalculationLog::with('user')
            ->latest()
            ->take(8)
            ->get();

        // System status
        $activeVersion = TaxVersion::where('is_active', true)->first();
        $exchangeRatesStatus = ExchangeRate::where('effective_date', today())->exists();
        $pendingUpdates = TaxVersion::where('effective_from', '>', now())->count();

        // Popular HS codes (based on calculation frequency)
        $popularHsCodes = CalculationLog::selectRaw('JSON_UNQUOTE(JSON_EXTRACT(input, "$.hs_code")) as hs_code, COUNT(*) as count')
            ->groupBy('hs_code')
            ->orderByDesc('count')
            ->take(5)
            ->get()
            ->map(function($item) {
                $hsCode = HsCode::where('hs_code', $item->hs_code)->first();
                return [
                    'code' => $item->hs_code,
                    'description' => $hsCode->description ?? 'Unknown',
                    'count' => $item->count
                ];
            });

        return view('admin.dashboard', compact(
            'stats',
            'recentCalculations',
            'activeVersion',
            'exchangeRatesStatus',
            'pendingUpdates',
            'popularHsCodes'
        ));
    }

    public function seedData(Request $request)
    {
        // Your seed data logic here
        return redirect()->route('admin.dashboard')
            ->with('success', 'Sample data seeded successfully.');
    }
}