<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as LaravelBaseController;
use Illuminate\Http\Request;

class BaseController extends LaravelBaseController
{
    use AuthorizesRequests, ValidatesRequests;

    protected $perPage = 20;

    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            if (!auth()->check()) {
                return redirect()->route('login');
            }

            if (!auth()->user()->is_admin) {
                abort(403, 'Admin access required.');
            }

            return $next($request);
        });
    }

    protected function getSortParams(Request $request, $defaultSort = 'created_at', $defaultDirection = 'desc')
    {
        return [
            'sort' => $request->get('sort', $defaultSort),
            'direction' => $request->get('direction', $defaultDirection),
        ];
    }

    protected function successResponse($message, $route = null, $data = [])
    {
        if (request()->expectsJson()) {
            return response()->json([
                'success' => true,
                'message' => $message,
                'data' => $data
            ]);
        }

        if ($route) {
            return redirect()->route($route)->with('success', $message);
        }

        return redirect()->back()->with('success', $message);
    }

    protected function errorResponse($message, $route = null, $errors = [])
    {
        if (request()->expectsJson()) {
            return response()->json([
                'success' => false,
                'message' => $message,
                'errors' => $errors
            ], 422);
        }

        if ($route) {
            return redirect()->route($route)->with('error', $message);
        }

        return redirect()->back()->with('error', $message)->withErrors($errors);
    }
}