<?php

namespace App\Helpers;

use App\Models\Setting;
use Illuminate\Support\Facades\Storage;

class SettingsHelper
{
    public static function get($key, $default = null)
    {
        return Setting::get($key, $default);
    }

    public static function app_logo()
    {
        $logoPath = self::get('app_logo');
        if ($logoPath && Storage::disk('public')->exists($logoPath)) {
            return Storage::disk('public')->url($logoPath);
        }
        return null;
    }

    public static function company_name()
    {
        return self::get('company_name', 'Kenya Import Tax Simulator');
    }

    public static function contact_email()
    {
        return self::get('contact_email', 'eflixdigital.com');
    }

    public static function whatsapp_number()
    {
        return self::get('whatsapp_number', '254736857813');
    }

    public static function support_phone()
    {
        return self::get('support_phone', '+254 736857813');
    }

    public static function business_hours()
    {
        return self::get('business_hours', 'Mon-Fri: 8AM-5PM EAT');
    }
}