<?php

namespace App\Console\Commands;

use App\Models\User;
use Illuminate\Console\Command;

class DebugAdminAccess extends Command
{
    protected $signature = 'debug:admin-access {email}';
    protected $description = 'Debug admin access issues';

    public function handle()
    {
        $email = $this->argument('email');
        $user = User::with('role')->where('email', $email)->first();

        if (!$user) {
            $this->error("User not found: {$email}");
            return 1;
        }

        $this->info("=== ADMIN ACCESS DEBUG ===");
        $this->info("User: {$user->name} <{$user->email}>");
        $this->info("ID: {$user->id}");
        $this->info("Is Admin: " . ($user->is_admin ? '✅ Yes' : '❌ No'));
        $this->info("Is Active: " . ($user->is_active ? '✅ Yes' : '❌ No'));
        
        $this->info("\n=== ROLE INFORMATION ===");
        if ($user->role) {
            $this->info("Role: {$user->role->name} ({$user->role->slug})");
            $this->info("Permissions: " . json_encode($user->role->permissions));
        } else {
            $this->error("❌ No role assigned");
        }

        $this->info("\n=== FIRST ADMIN CHECK ===");
        $firstAdmin = User::where('is_admin', true)->orderBy('id')->first();
        $this->info("First Admin ID: {$firstAdmin->id}");
        $this->info("Current User ID: {$user->id}");
        $this->info("Is First Admin: " . ($user->isFirstAdmin() ? '✅ Yes' : '❌ No'));

        $this->info("\n=== PERMISSION CHECKS ===");
        $this->info("Has users.*: " . ($user->hasPermission('users.*') ? '✅ Yes' : '❌ No'));
        $this->info("Has users.edit: " . ($user->hasPermission('users.edit') ? '✅ Yes' : '❌ No'));
        $this->info("Can access user edit: " . ($user->isFirstAdmin() || $user->hasPermission('users.edit') ? '✅ Yes' : '❌ No'));

        $this->info("\n=== MIDDLEWARE CHECK ===");
        $this->info("Using middleware: auth, admin.permission");
        $this->info("First admin should bypass all permission checks");

        return 0;
    }
}