<?php

namespace App\Console\Commands;

use App\Models\User;
use App\Models\AdminRole;
use Illuminate\Console\Command;

class AssignAdminRoles extends Command
{
    protected $signature = 'admin:assign-roles';
    protected $description = 'Assign admin roles to existing admin users';

    public function handle()
    {
        $superAdminRole = AdminRole::where('slug', 'super_admin')->first();
        
        if (!$superAdminRole) {
            $this->error('Super admin role not found!');
            return 1;
        }

        $adminUsers = User::where('is_admin', true)->get();
        
        foreach ($adminUsers as $user) {
            $user->update(['role_id' => $superAdminRole->id]);
            $this->info("Assigned super admin role to: {$user->email}");
        }

        $this->info('Admin roles assigned successfully!');
        return 0;
    }
}  