<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]); ?>
<?php foreach (array_filter(([
    'services' => [],
    'currencies' => [],
    'selectedServices' => [],
    'baseCurrency' => 'KES'
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<?php
    // Convert selectedServices to a proper array and ensure it has the required fields
    $processedServices = [];
    $totalCost = 0;
    $totalCharge = 0;
    $totalCostKES = 0;
    $totalChargeKES = 0;

    if (!empty($selectedServices)) {
        foreach ($selectedServices as $index => $service) {
            // Convert to array if it's an object
            $serviceArray = is_object($service) ? $service->toArray() : $service;
            
            // Ensure all required fields exist
            $serviceArray['id'] = $serviceArray['id'] ?? $index;
            $serviceArray['currency'] = $serviceArray['currency'] ?? $baseCurrency;
            $serviceArray['cost'] = $serviceArray['cost'] ?? 0;
            $serviceArray['charge'] = $serviceArray['charge'] ?? 0;
            $serviceArray['cost_kes'] = $serviceArray['cost_kes'] ?? $serviceArray['cost'];
            $serviceArray['charge_kes'] = $serviceArray['charge_kes'] ?? $serviceArray['charge'];
            
            $processedServices[] = $serviceArray;
            
            // Calculate totals
            $totalCost += $serviceArray['cost'];
            $totalCharge += $serviceArray['charge'];
            $totalCostKES += $serviceArray['cost_kes'];
            $totalChargeKES += $serviceArray['charge_kes'];
        }
    }
    
    $totalProfit = $totalChargeKES - $totalCostKES;
?>

<div class="card mb-4 card-section" id="servicesSection">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>Extra Services</span>
        <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#servicesHelpModal">
            <i class="ri-information-line"></i> Help
        </button>
    </div>
    <div class="card-body">
        <div class="row g-3 mb-3">
            <div class="col-md-4">
                <label class="form-label">Service</label>
                <select class="form-select" id="service_id" required>
                    <option value="">-- Select --</option>
                    <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($service->id); ?>" 
                                data-description="<?php echo e($service->description); ?>"
                                data-default-cost="<?php echo e($service->default_cost); ?>"
                                data-default-charge="<?php echo e($service->default_charge); ?>"
                                data-currency="<?php echo e($service->default_currency); ?>">
                            <?php echo e($service->name); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
                <div class="invalid-feedback">Please select a service</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Cost</label>
                <input type="number" step="0.01" min="0" class="form-control" id="service_cost" placeholder="0.00" required>
                <div class="invalid-feedback">Please enter a valid cost</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Charge</label>
                <input type="number" step="0.01" min="0" class="form-control" id="service_charge" placeholder="0.00" required>
                <div class="invalid-feedback">Please enter a valid charge</div>
            </div>
            <div class="col-md-2">
                <label class="form-label">Currency</label>
                <select class="form-select" id="service_currency" required>
                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($currency->code); ?>" 
                                data-buy-rate="<?php echo e($currency->buying_exchange_rate); ?>"
                                data-sell-rate="<?php echo e($currency->selling_exchange_rate); ?>"
                                <?php echo e($currency->code === $baseCurrency ? 'selected' : ''); ?>>
                            <?php echo e($currency->code); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="button" class="btn btn-primary w-100" id="addService">
                    <i class="ri-add-line"></i> Add
                </button>
            </div>
        </div>

        <div class="service-description mb-3 alert alert-info d-none" id="serviceDescription"></div>
        
        <div class="d-flex justify-content-between align-items-center mb-3">
            <div class="estimated-profit alert alert-success py-1 px-2 mb-0 d-none" id="estimatedProfitDisplay">
                Estimated Profit: 0.00 <?php echo e($baseCurrency); ?>

            </div>
            <button type="button" class="btn btn-sm btn-outline-secondary" id="clearServices">
                <i class="ri-close-line"></i> Clear All
            </button>
        </div>

        <div class="table-responsive">
            <table class="table table-bordered table-hover" id="servicesTable">
                <thead class="table-light">
                    <tr>
                        <th>Service</th>
                        <th>Currency</th>
                        <th>Cost</th>
                        <th>Charge</th>
                        <th>Cost (<?php echo e($baseCurrency); ?>)</th>
                        <th>Charge (<?php echo e($baseCurrency); ?>)</th>
                        <th>Profit</th>
                        <th width="100px">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($processedServices) > 0): ?>
                        <?php $__currentLoopData = $processedServices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr data-service-id="<?php echo e($service['id']); ?>">
                                <td>
                                    <?php echo e($services->find($service['id'])->name ?? $service['id']); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][id]" value="<?php echo e($service['id']); ?>">
                                </td>
                                <td>
                                    <?php echo e($service['currency']); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][currency]" value="<?php echo e($service['currency']); ?>">
                                </td>
                                <td>
                                    <?php echo e(number_format($service['cost'], 2)); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][cost]" value="<?php echo e($service['cost']); ?>">
                                </td>
                                <td>
                                    <?php echo e(number_format($service['charge'], 2)); ?>

                                    <input type="hidden" name="services[<?php echo e($index); ?>][charge]" value="<?php echo e($service['charge']); ?>">
                                </td>
                                <td><?php echo e(number_format($service['cost_kes'], 2)); ?></td>
                                <td><?php echo e(number_format($service['charge_kes'], 2)); ?></td>
                                <td class="<?php echo e(($service['charge_kes'] - $service['cost_kes']) >= 0 ? 'text-success' : 'text-danger'); ?>">
                                    <?php echo e(number_format($service['charge_kes'] - $service['cost_kes'], 2)); ?>

                                </td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-danger remove-service" title="Remove">
                                        <i class="ri-delete-bin-line"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <tr id="noServicesRow">
                            <td colspan="8" class="text-center py-4 text-muted">No services added yet</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
                <tfoot class="table-light">
                    <tr>
                        <th colspan="2">Totals</th>
                        <th id="totalCost"><?php echo e(number_format($totalCost, 2)); ?></th>
                        <th id="totalCharge"><?php echo e(number_format($totalCharge, 2)); ?></th>
                        <th id="totalCostKES"><?php echo e(number_format($totalCostKES, 2)); ?></th>
                        <th id="totalChargeKES"><?php echo e(number_format($totalChargeKES, 2)); ?></th>
                        <th id="totalProfit" class="<?php echo e($totalProfit >= 0 ? 'text-success' : 'text-danger'); ?>">
                            <?php echo e(number_format($totalProfit, 2)); ?>

                        </th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>

<!-- Services Help Modal -->
<div class="modal fade" id="servicesHelpModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Extra Services Help</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p><strong>Cost:</strong> What you pay for the service</p>
                <p><strong>Charge:</strong> What you charge the customer</p>
                <p><strong>Profit:</strong> Charge minus Cost (converted to <?php echo e($baseCurrency); ?>)</p>
                <p class="mb-0">Services are optional and can be added to increase your revenue.</p>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/services.blade.php ENDPATH**/ ?>