
<?php $isEdit = isset($route); ?>

<form action="<?php echo e($isEdit ? route('shipment-routes.update', $route) : route('shipment-routes.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <?php if($isEdit): ?>
        <?php echo method_field('PUT'); ?>
    <?php endif; ?>

    <div class="row">
        <div class="col-md-6">
            <label>Origin Country</label>
            <select name="origin_country_id" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->id); ?>"
                        <?php echo e(old('origin_country_id', $route->origin_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                        <?php echo e($country->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-6">
            <label>Destination Country</label>
            <select name="destination_country_id" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($country->id); ?>"
                        <?php echo e(old('destination_country_id', $route->destination_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                        <?php echo e($country->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-6 mt-3">
            <label>Shipment Mode</label>
            <select name="shipment_mode_id" id="shipment_mode_select" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $shipmentModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($mode->id); ?>"
                        data-measure="<?php echo e($mode->measure->code ?? ''); ?>"
                        <?php echo e(old('shipment_mode_id', $route->shipment_mode_id ?? '') == $mode->id ? 'selected' : ''); ?>>
                        <?php echo e($mode->name); ?> (<?php echo e($mode->measure->code ?? '?'); ?>)
                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-6 mt-3">
            <label>Cargo Category</label>
            <select name="cargo_category_id" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $cargoCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($category->id); ?>"
                        <?php echo e(old('cargo_category_id', $route->cargo_category_id ?? '') == $category->id ? 'selected' : ''); ?>>
                        <?php echo e($category->name); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-4 mt-3">
            <label>Currency</label>
            <select name="currency_id" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($currency->id); ?>"
                        <?php echo e(old('currency_id', $route->currency_id ?? '') == $currency->id ? 'selected' : ''); ?>>
                        <?php echo e($currency->code); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>

        <div class="col-md-4 mt-3">
            <label>Rate Per Unit</label>
            <input type="number" name="rate_per_unit" class="form-control" step="0.01"
                value="<?php echo e(old('rate_per_unit', $route->rate_per_unit ?? '')); ?>">
        </div>

        <div class="col-md-4 mt-3">
            <label>Flat Rate</label>
            <input type="number" name="flat_rate" class="form-control" step="0.01"
                value="<?php echo e(old('flat_rate', $route->flat_rate ?? '')); ?>">
        </div>

        <div class="col-md-4 mt-3">
            <label>Minimum Weight (<span id="unit_label"><?php echo e(old('unit_type', $route->unit_type ?? 'unit')); ?></span>)</label>
            <input type="number" name="minimum_weight" class="form-control" step="0.01"
                value="<?php echo e(old('minimum_weight', $route->minimum_weight ?? '')); ?>">
        </div>

        <div class="col-md-4 mt-3">
            <label>Unit Type</label>
            <input type="text" name="unit_type" id="unit_type_input" class="form-control"
                value="<?php echo e(old('unit_type', $route->unit_type ?? '')); ?>" readonly>
        </div>

        <div class="col-md-4 mt-3">
            <label>Weight Basis</label>
            <select name="weight_basis" class="form-control" required>
                <option value="">Select</option>
                <?php $__currentLoopData = ['gross', 'volumetric', 'higher']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $basis): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($basis); ?>"
                        <?php echo e(old('weight_basis', $route->weight_basis ?? '') == $basis ? 'selected' : ''); ?>>
                        <?php echo e(ucfirst($basis)); ?>

                    </option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="mt-4">
        <button class="btn btn-success" type="submit">
            <?php echo e($isEdit ? 'Update' : 'Create'); ?> Route
        </button>
        <a href="<?php echo e(route('shipment-routes.index')); ?>" class="btn btn-secondary">Cancel</a>
    </div>
</form>


<script>
    document.addEventListener('DOMContentLoaded', () => {
        const modeSelect = document.getElementById('shipment_mode_select');
        const unitInput = document.getElementById('unit_type_input');
        const unitLabel = document.getElementById('unit_label');

        const updateUnitType = () => {
            const selectedOption = modeSelect.options[modeSelect.selectedIndex];
            const measure = selectedOption.dataset.measure || '';
            unitInput.value = measure;
            unitLabel.textContent = measure || 'unit';
        };

        if (modeSelect && unitInput) {
            modeSelect.addEventListener('change', updateUnitType);
            updateUnitType(); // Run once on load
        }
    });
</script>
<?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipment_routes/_form.blade.php ENDPATH**/ ?>