<?php
use App\Models\Currency;
$baseCurrency = Currency::base()->code;
$currencies = Currency::all();
?>

<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'action' => route('shipments.store'),
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'serviceProviders' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'action' => route('shipments.store'),
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'serviceProviders' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]); ?>
<?php foreach (array_filter(([
    'action' => route('shipments.store'),
    'method' => 'POST',
    'shipment' => null,
    'customers' => [],
    'countries' => [],
    'shipmentModes' => [],
    'cargoCategories' => [],
    'services' => [],
    'serviceProviders' => [],
    'currencies' => $currencies,
    'baseCurrency' => $baseCurrency
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<div class="shipping-application">
    <!-- System Status Bar -->
    <div class="system-status-bar alert alert-info d-flex align-items-center mb-4">
        <i class="ri-information-line me-2"></i>
        <span id="systemStatus">Ready to create new shipment</span>
        <div class="ms-auto">
            <span class="badge bg-primary" id="formStepIndicator">Step 1 of 6</span>
        </div>
    </div>

    <form id="shipmentForm" method="POST" action="<?php echo e($action); ?>" class="card p-4" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php if($method !== 'POST'): ?>
            <?php echo method_field($method); ?>
        <?php endif; ?>

        <!-- Hidden Fields -->
        <input type="hidden" name="base_currency" value="<?php echo e($baseCurrency); ?>">
        <input type="hidden" name="original_currency" id="originalCurrency" value="<?php echo e($baseCurrency); ?>">
        <input type="hidden" name="exchange_rate" id="exchangeRate" value="1">
        <input type="hidden" name="shipment_status" id="shipmentStatus" value="draft">
        <input type="hidden" name="otp_verification_code" id="otpVerificationCode">
        <input type="hidden" name="otp_verified" id="otpVerified" value="0">
        <input type="hidden" name="profit_amount" id="profitAmount" value="0">
        <input type="hidden" name="whatsapp_sent" id="whatsappSent" value="0">

        <!-- Step 1: Customer Information -->
        <?php echo $__env->make('shipments.partials.customer-info', [
            'customers' => $customers,
            'shipment' => $shipment,
            'countries' => $countries
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Step 2: Package Details -->
        <?php echo $__env->make('shipments.partials.package-details', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Step 3: Route & Shipment Details -->
        <?php echo $__env->make('shipments.partials.route-details', [
            'countries' => $countries,
            'shipmentModes' => $shipmentModes,
            'cargoCategories' => $cargoCategories,
            'serviceProviders' => $serviceProviders,
            'shipment' => $shipment
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Step 4: Service Provider & Pricing -->
        <?php echo $__env->make('shipments.partials.pricing-details', [
            'serviceProviders' => $serviceProviders,
            'currencies' => $currencies,
            'baseCurrency' => $baseCurrency
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Step 5: Extra Services -->
        <?php echo $__env->make('shipments.partials.services', [
            'services' => $services,
            'currencies' => $currencies,
            'selectedServices' => $shipment->services ?? []
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <!-- Step 6: OTP Verification & Finalization -->
        <?php echo $__env->make('shipments.partials.verification-payment', [
            'baseCurrency' => $baseCurrency
        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </form>

    <!-- Modals -->
    <?php echo $__env->make('shipments.partials.modals.customer-modal', ['countries' => $countries], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('shipments.partials.modals.manual-rate-modal', ['currencies' => $currencies, 'baseCurrency' => $baseCurrency], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('shipments.partials.modals.otp-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('shipments.partials.modals.waybill-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php $__env->startPush('styles'); ?>
<style>
    .card-section { 
        margin-bottom: 1.5rem; 
        border: 1px solid #e9ecef; 
        border-radius: 0.5rem; 
        transition: all 0.3s ease;
    }
    .card-section .card-header { 
        background-color: #f8f9fa; 
        padding: 1rem 1.25rem; 
        border-bottom: 1px solid #e9ecef;
    }
    .card-section .card-header button { 
        font-weight: 600; 
        color: #495057;
        border: none;
        background: none;
        width: 100%;
        text-align: left;
    }
    .card-section .card-header button:hover {
        color: #0d6efd;
    }
    .required-field::after { 
        content: " *"; 
        color: #dc3545; 
    }
    .summary-section { 
        background-color: #f8f9fa; 
        padding: 1rem; 
        border-radius: 0.5rem; 
        border-left: 4px solid #0d6efd;
    }
    .payment-option { 
        flex: 1; 
        text-align: center; 
        padding: 1rem; 
        border: 2px solid #dee2e6; 
        border-radius: 0.5rem; 
        cursor: pointer; 
        transition: all 0.3s; 
    }
    .payment-option:hover, .payment-option.active { 
        background-color: #e7f1ff; 
        border-color: #0c63e4; 
        transform: translateY(-2px);
    }
    .profit-display { 
        background-color: #d4edda; 
        padding: 0.5rem; 
        border-radius: 0.25rem; 
        font-weight: bold; 
        border-left: 4px solid #28a745;
    }
    .service-provider-rate { 
        background-color: #fff3cd; 
        padding: 0.5rem; 
        border-radius: 0.25rem; 
        border-left: 4px solid #ffc107;
    }
    .otp-timer {
        font-family: 'Courier New', monospace;
        font-weight: bold;
        color: #dc3545;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<!-- Load modules in correct order -->
<script src="<?php echo e(asset('js/shipment/modules/utilities.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/step-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/customer-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/package-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/route-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/pricing-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/services-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/verification-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/shipment/modules/modal-manager.js')); ?>"></script>

<!-- Main shipment file -->
<script src="<?php echo e(asset('js/shipment/shipment.js')); ?>"></script>

<!-- Global functions with error handling -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Customer functions
    window.saveNewCustomer = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('customerManager')) {
            window.shipmentForm.getModule('customerManager').saveNewCustomer();
        } else {
            console.error('Customer manager not available');
            alert('Customer manager not available. Please refresh the page.');
        }
    }

    window.validateCustomerSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('customerManager')) {
            window.shipmentForm.getModule('customerManager').validateSection();
        } else {
            console.error('Customer manager not available');
        }
    }

    // Package functions
    window.validatePackagesSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('packageManager')) {
            window.shipmentForm.getModule('packageManager').validateSection();
        } else {
            console.error('Package manager not available');
        }
    }

    // Route functions
    window.validateRouteSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('routeManager')) {
            window.shipmentForm.getModule('routeManager').validateSection();
        } else {
            console.error('Route manager not available');
        }
    }

    // Pricing functions
    window.validatePricingSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('pricingManager')) {
            window.shipmentForm.getModule('pricingManager').validateSection();
        } else {
            console.error('Pricing manager not available');
        }
    }

    window.applyManualRate = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('pricingManager')) {
            window.shipmentForm.getModule('pricingManager').applyManualRate();
        } else {
            console.error('Pricing manager not available');
        }
    }

    // Services functions
window.validateServicesSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('servicesManager')) {
            window.shipmentForm.getModule('servicesManager').validateSection();
        } else {
            console.error('Services manager not available');
            // Fallback: move to next step
            const stepManager = window.shipmentForm.getModule('stepManager');
            if (stepManager) {
                stepManager.moveToStep(6);
            }
        }
    }
    
    // Verification functions
    window.validateVerificationSection = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            window.shipmentForm.getModule('verificationManager').validateSection();
        } else {
            console.error('Verification manager not available');
        }
    }

    // Additional verification functions
    window.verifyModalOTP = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            // Check if the method exists
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.verifyModalOTP) {
                verificationManager.verifyModalOTP();
            } else {
                alert('OTP verification not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.resendOTP = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.resendOTP) {
                verificationManager.resendOTP();
            } else {
                alert('OTP resend not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.sendWaybillWhatsApp = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.sendWaybillWhatsApp) {
                verificationManager.sendWaybillWhatsApp();
            } else {
                alert('WhatsApp sending not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.printWaybill = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.printWaybill) {
                verificationManager.printWaybill();
            } else {
                alert('Waybill printing not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.generateWaybillPreview = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.generateWaybillPreview) {
                verificationManager.generateWaybillPreview();
            } else {
                alert('Waybill preview not available in this version.');
            }
        } else {
            console.error('Verification manager not available');
        }
    }

    window.saveAsDraft = function() {
        if (window.shipmentForm && window.shipmentForm.getModule('verificationManager')) {
            const verificationManager = window.shipmentForm.getModule('verificationManager');
            if (verificationManager.saveAsDraft) {
                verificationManager.saveAsDraft();
            } else {
                // Fallback: set status to draft and submit
                document.getElementById('shipmentStatus').value = 'draft';
                document.getElementById('shipmentForm').submit();
            }
        } else {
            // Fallback method
            document.getElementById('shipmentStatus').value = 'draft';
            document.getElementById('shipmentForm').submit();
        }
    }

    // Add this to the global functions in resources/views/shipments/form.blade.php
window.searchCustomerByPhone = function() {
    if (window.shipmentForm && window.shipmentForm.getModule('customerManager')) {
        window.shipmentForm.getModule('customerManager').searchCustomerByPhone();
    } else {
        console.error('Customer manager not available');
        alert('Customer manager not available. Please refresh the page.');
    }
}
});

</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/form.blade.php ENDPATH**/ ?>