<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    
    <?php echo $__env->make('partials.head-css', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title><?php echo e($title ?? 'Smart Shipping System'); ?></title>
</head>
<body>
    <?php echo $__env->make('partials.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="layout-wrapper">
        <?php echo $__env->make('partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="main-content">
            <div class="page-content">
                <div class="container-fluid">
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>

            <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        </div>
    </div>

    
    <?php echo $__env->make('partials.vendor-scripts', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <!-- Helpers first -->
<script src="<?php echo e(asset('js/suppliers/utils/helpers.js')); ?>"></script>

<!-- Modules -->
<script src="<?php echo e(asset('js/suppliers/modules/dashboard.js')); ?>"></script>
<script src="<?php echo e(asset('js/suppliers/modules/search-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/suppliers/modules/export-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/suppliers/modules/modal-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/suppliers/modules/vendor-manager.js')); ?>"></script>
<script src="<?php echo e(asset('js/suppliers/modules/app-shell.js')); ?>"></script>

<!-- Entrypoint -->
<script src="<?php echo e(asset('js/suppliers/suppliers.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/layouts/clivax.blade.php ENDPATH**/ ?>