<div class="card mb-4 card-section">
    <div class="card-header">
        <button class="btn btn-link text-decoration-none w-100 text-start" type="button" data-bs-toggle="collapse" data-bs-target="#routeInfoCollapse" aria-expanded="false">
            <i class="ri-route-line me-2"></i> 
            <span class="fw-semibold">Step 3: Route & Shipment Details</span>
            <span class="badge bg-secondary ms-2" id="routeStepStatus">3</span>
        </button>
    </div>
    <div class="collapse" id="routeInfoCollapse" data-bs-parent="#shipmentForm">
        <div class="card-body">
            <!-- Package Summary Display -->
            <div id="shipmentSummary" class="summary-section mb-4">
                <p><strong>Package Summary:</strong> <span id="summaryPackages">0</span> packages, Total Weight: <span id="summaryWeight">0</span> kgs</p>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label>Origin Country</label>
                    <select name="origin_country_id" id="origin_country_id" class="form-control" required>
                        <option value="">Select Origin</option>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->id); ?>" 
                                <?php echo e(old('origin_country_id', $shipment->origin_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                                <?php echo e($country->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Destination Country</label>
                    <select name="destination_country_id" id="destination_country_id" class="form-control" required>
                        <option value="">Select Destination</option>
                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($country->id); ?>" 
                                <?php echo e(old('destination_country_id', $shipment->destination_country_id ?? '') == $country->id ? 'selected' : ''); ?>>
                                <?php echo e($country->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Shipment Mode</label>
                    <select name="shipment_mode_code" id="shipment_mode_select" class="form-control" required>
                        <option value="">Select Mode</option>
                        <?php $__currentLoopData = $shipmentModes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mode): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($mode->code); ?>" 
                                data-measure="<?php echo e($mode->measure->code ?? ''); ?>"
                                <?php echo e(old('shipment_mode_code', $shipment->shipment_mode_code ?? '') == $mode->code ? 'selected' : ''); ?>>
                                <?php echo e($mode->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-3">
                    <label>Cargo Category</label>
                    <select name="cargo_category_id" id="cargo_category_id" class="form-control" required>
                        <option value="">Select Category</option>
                        <?php $__currentLoopData = $cargoCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($cat->id); ?>" 
                                <?php echo e(old('cargo_category_id', $shipment->cargo_category_id ?? '') == $cat->id ? 'selected' : ''); ?>>
                                <?php echo e($cat->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <!-- Tracking Number -->
            <div class="row mt-3">
                <div class="col-md-6 mb-3">
                    <label for="tracking_number" class="form-label">Tracking Number</label>
                    <div class="input-group">
                        <input type="text" id="tracking_number" name="tracking_number" class="form-control readonly-field" readonly>
                        <button type="button" class="btn btn-outline-secondary" id="generateTrackingBtn">
                            <i class="ri-refresh-line"></i> Generate
                        </button>
                    </div>
                </div>
                <div class="col-md-6 mb-3">
                    <label for="shipment_reference" class="form-label">Shipment Reference</label>
                    <input type="text" id="shipment_reference" name="shipment_reference" class="form-control" placeholder="Optional reference">
                </div>
            </div>

            <!-- Consignee Information -->
            <?php echo $__env->make('shipments.partials.consignee-info', ['countries' => $countries], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <div class="mt-3">
                <button type="button" class="btn btn-success" onclick="validateRouteSection()">
                    <i class="ri-check-line"></i> Confirm Route Details
                </button>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/shipments/partials/route-details.blade.php ENDPATH**/ ?>