

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">High Value Customers Report</h4>
            <div>
                <a href="<?php echo e(route('customer-reports.index')); ?>" class="btn btn-secondary me-2">
                    <i class="ri-arrow-left-line"></i> Back to Reports
                </a>
                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-primary">
                    <i class="ri-user-line"></i> Customers
                </a>
            </div>
        </div>

        <!-- High Value Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6>High Value Customers</h6>
                        <h3><?php echo e($customers->count()); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6>Total Revenue</h6>
                        <h3>$<?php echo e(number_format($customers->sum('total_revenue'), 2)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h6>Avg. Revenue</h6>
                        <h3>$<?php echo e(number_format($customers->avg('total_revenue'), 2)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h6>Top Customer</h6>
                        <h6>$<?php echo e(number_format($customers->max('total_revenue'), 2)); ?></h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customer Tiers -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Customer Tiers</h6>
                        <div class="row text-center">
                            <div class="col-md-4">
                                <div class="border rounded p-3">
                                    <h4 class="text-warning">Gold Tier</h4>
                                    <h5>$1,000+</h5>
                                    <p class="mb-0"><?php echo e($customers->where('total_revenue', '>=', 5000)->count()); ?> customers</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="border rounded p-3">
                                    <h4 class="text-secondary">Silver Tier</h4>
                                    <h5>$500 - $999</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [1000, 4999])->count()); ?> customers</p>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="border rounded p-3">
                                    <h4 class="text-bronze">Bronze Tier</h4>
                                    <h5>$100 - $499</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [500, 999])->count()); ?> customers</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- High Value Customers Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Rank</th>
                                <th>Customer</th>
                                <th>Customer Type</th>
                                <th>Total Revenue</th>
                                <th>Shipments</th>
                                <th>Avg. Shipment</th>
                                <th>First Shipment</th>
                                <th>Last Shipment</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <span class="badge bg-<?php echo e($index < 3 ? 'warning' : 'secondary'); ?>">
                                        #<?php echo e($index + 1); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-primary rounded-circle text-white d-flex align-items-center justify-content-center me-2" 
                                             style="width: 32px; height: 32px;">
                                            <?php echo e(strtoupper(substr($customer->name, 0, 1))); ?>

                                        </div>
                                        <div>
                                            <strong><?php echo e($customer->name); ?></strong>
                                            <?php if($customer->company_name): ?>
                                                <br><small class="text-muted"><?php echo e($customer->company_name); ?></small>
                                            <?php endif; ?>
                                            <br><small class="text-muted"><?php echo e($customer->phone); ?></small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($customer->customer_type == 'business' ? 'info' : ($customer->customer_type == 'corporate' ? 'primary' : 'secondary')); ?>">
                                        <?php echo e(ucfirst($customer->customer_type)); ?>

                                    </span>
                                </td>
                                <td class="text-success">
                                    <strong>$<?php echo e(number_format($customer->total_revenue, 2)); ?></strong>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark"><?php echo e($customer->total_shipments); ?></span>
                                </td>
                                <td>
                                    $<?php echo e(number_format($customer->average_shipment_value, 2)); ?>

                                </td>
                                <td>
                                    <?php echo e($customer->first_shipment_date ? $customer->first_shipment_date->format('M d, Y') : 'Never'); ?>

                                </td>
                                <td>
                                    <?php echo e($customer->last_shipment_date ? $customer->last_shipment_date->format('M d, Y') : 'Never'); ?>

                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'blocked' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($customer->status)); ?>

                                    </span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Revenue Distribution -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Revenue by Customer Type</h6>
                        <canvas id="revenueByTypeChart" height="250"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Customers by Type</h6>
                        <canvas id="customersByTypeChart" height="250"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Revenue by Type Chart
    const revenueByTypeCtx = document.getElementById('revenueByTypeChart').getContext('2d');
    new Chart(revenueByTypeCtx, {
        type: 'doughnut',
        data: {
            labels: ['Individual', 'Business', 'Corporate'],
            datasets: [{
                data: [
                    <?php echo e($customers->where('customer_type', 'individual')->sum('total_revenue')); ?>,
                    <?php echo e($customers->where('customer_type', 'business')->sum('total_revenue')); ?>,
                    <?php echo e($customers->where('customer_type', 'corporate')->sum('total_revenue')); ?>

                ],
                backgroundColor: ['#6c757d', '#0dcaf0', '#0d6efd']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });

    // Customers by Type Chart
    const customersByTypeCtx = document.getElementById('customersByTypeChart').getContext('2d');
    new Chart(customersByTypeCtx, {
        type: 'pie',
        data: {
            labels: ['Individual', 'Business', 'Corporate'],
            datasets: [{
                data: [
                    <?php echo e($customers->where('customer_type', 'individual')->count()); ?>,
                    <?php echo e($customers->where('customer_type', 'business')->count()); ?>,
                    <?php echo e($customers->where('customer_type', 'corporate')->count()); ?>

                ],
                backgroundColor: ['#6c757d', '#0dcaf0', '#0d6efd']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>

<style>
.avatar-sm {
    font-size: 14px;
    font-weight: bold;
}
.text-bronze {
    color: #cd7f32 !important;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/customers/reports/high-value.blade.php ENDPATH**/ ?>