
<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag; ?>
<?php foreach($attributes->onlyProps([
    'currency' => null, // The currency model (null for create)
    'action' => '',     // Form action URL
    'method' => 'POST', // Form method (POST for create, PUT/PATCH for edit)
]) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $attributes = $attributes->exceptProps([
    'currency' => null, // The currency model (null for create)
    'action' => '',     // Form action URL
    'method' => 'POST', // Form method (POST for create, PUT/PATCH for edit)
]); ?>
<?php foreach (array_filter(([
    'currency' => null, // The currency model (null for create)
    'action' => '',     // Form action URL
    'method' => 'POST', // Form method (POST for create, PUT/PATCH for edit)
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
} ?>
<?php $__defined_vars = get_defined_vars(); ?>
<?php foreach ($attributes as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
} ?>
<?php unset($__defined_vars); ?>

<form action="<?php echo e($action); ?>" method="POST" class="needs-validation" novalidate>
    <?php echo csrf_field(); ?>
    <?php echo method_field($method); ?>

    <div class="row g-3">
        
        <div class="col-md-6 mb-3">
            <label for="code" class="form-label">Currency Code <span class="text-danger">*</span></label>
            <input type="text" 
                   class="form-control <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                   id="code" 
                   name="code" 
                   value="<?php echo e(old('code', $currency->code ?? '')); ?>"
                   required
                   maxlength="3"
                   pattern="[A-Z]{3}"
                   title="3-letter uppercase currency code (e.g. USD, EUR)"
                   <?php if($currency): ?> readonly <?php endif; ?>>
            <div class="invalid-feedback">
                <?php $__errorArgs = ['code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> Please provide a valid 3-letter currency code. <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <small class="form-text text-muted">ISO 4217 currency code (e.g. USD, EUR, GBP)</small>
        </div>

        
        <div class="col-md-6 mb-3">
            <label for="name" class="form-label">Currency Name <span class="text-danger">*</span></label>
            <input type="text" 
                   class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                   id="name" 
                   name="name" 
                   value="<?php echo e(old('name', $currency->name ?? '')); ?>"
                   required>
            <div class="invalid-feedback">
                <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> Please provide the currency name. <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
        </div>

        
        <div class="col-md-6 mb-3">
            <label for="symbol" class="form-label">Currency Symbol</label>
            <input type="text" 
                   class="form-control <?php $__errorArgs = ['symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                   id="symbol" 
                   name="symbol" 
                   value="<?php echo e(old('symbol', $currency->symbol ?? '')); ?>"
                   maxlength="5">
            <div class="invalid-feedback">
                <?php $__errorArgs = ['symbol'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
            </div>
            <small class="form-text text-muted">Symbol used to represent the currency (e.g. $, €, £)</small>
        </div>

        
        <div class="col-md-6 mb-3">
            <label for="buying_exchange_rate" class="form-label">Buying Rate (vs KES) <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text">1 <?php echo e($currency?->code ?? 'NEW'); ?> =</span>
                <input type="number" 
                       class="form-control <?php $__errorArgs = ['buying_exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="buying_exchange_rate" 
                       name="buying_exchange_rate" 
                       value="<?php echo e(old('buying_exchange_rate', $currency->buying_exchange_rate ?? '')); ?>"
                       step="0.0001"
                       min="0.0001"
                       required>
                <span class="input-group-text">KES</span>
                <div class="invalid-feedback">
                    <?php $__errorArgs = ['buying_exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> Please provide a valid buying rate. <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <small class="form-text text-muted">Rate at which we buy this currency (1 unit = X KES)</small>
        </div>

        
        <div class="col-md-6 mb-3">
            <label for="selling_exchange_rate" class="form-label">Selling Rate (vs KES) <span class="text-danger">*</span></label>
            <div class="input-group">
                <span class="input-group-text">1 <?php echo e($currency?->code ?? 'NEW'); ?> =</span>
                <input type="number" 
                       class="form-control <?php $__errorArgs = ['selling_exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                       id="selling_exchange_rate" 
                       name="selling_exchange_rate" 
                       value="<?php echo e(old('selling_exchange_rate', $currency->selling_exchange_rate ?? '')); ?>"
                       step="0.0001"
                       min="0.0001"
                       required>
                <span class="input-group-text">KES</span>
                <div class="invalid-feedback">
                    <?php $__errorArgs = ['selling_exchange_rate'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <?php echo e($message); ?> <?php else: ?> Please provide a valid selling rate. <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>
            </div>
            <small class="form-text text-muted">Rate at which we sell this currency (1 unit = X KES)</small>
        </div>

        
        <?php if($currency && $currency->services()->exists()): ?>
        <div class="col-12 alert alert-warning">
            <i class="ri-alert-line"></i> This currency is used by <?php echo e($currency->services()->count()); ?> services. 
            Changing rates may affect existing pricing.
        </div>
        <?php endif; ?>

        
        <div class="col-12 mt-4">
            <button type="submit" class="btn btn-primary me-2">
                <i class="ri-save-line"></i> <?php echo e($currency ? 'Update' : 'Save'); ?> Currency
            </button>
            <a href="<?php echo e(route('currencies.index')); ?>" class="btn btn-outline-secondary">
                <i class="ri-arrow-go-back-line"></i> Cancel
            </a>
            
            <?php if($currency && $currency->code !== 'KES'): ?>
                <button type="button" 
                        class="btn btn-danger float-end" 
                        data-bs-toggle="modal" 
                        data-bs-target="#deleteCurrencyModal"
                        <?php if($currency->services()->exists()): ?> disabled title="Cannot delete - currency is in use by services" <?php endif; ?>>
                    <i class="ri-delete-bin-line"></i> Delete
                </button>
            <?php endif; ?>
        </div>
    </div>
</form>


<?php if($currency && $currency->code !== 'KES' && !$currency->services()->exists()): ?>
<div class="modal fade" id="deleteCurrencyModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Confirm Deletion</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <p>Are you sure you want to delete the currency <strong><?php echo e($currency->code); ?> - <?php echo e($currency->name); ?></strong>?</p>
                <p class="text-danger">This action cannot be undone.</p>
                
                <?php if($currency->services()->exists()): ?>
                <div class="alert alert-danger">
                    <i class="ri-error-warning-line"></i> Warning: This currency is used by <?php echo e($currency->services()->count()); ?> services.
                </div>
                <?php endif; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <form action="<?php echo e(route('currencies.destroy', $currency->id)); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="submit" class="btn btn-danger" <?php if($currency->services()->exists()): ?> disabled <?php endif; ?>>
                        <i class="ri-delete-bin-line"></i> Confirm Delete
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->startPush('scripts'); ?>
<script>
// Client-side validation
document.addEventListener('DOMContentLoaded', function() {
    // Validate that selling rate >= buying rate
    const buyingRate = document.getElementById('buying_exchange_rate');
    const sellingRate = document.getElementById('selling_exchange_rate');
    
    function validateRates() {
        if (parseFloat(sellingRate.value) < parseFloat(buyingRate.value)) {
            sellingRate.setCustomValidity('Selling rate must be greater than or equal to buying rate');
        } else {
            sellingRate.setCustomValidity('');
        }
    }
    
    buyingRate.addEventListener('change', validateRates);
    sellingRate.addEventListener('change', validateRates);
    
    // Bootstrap validation
    const forms = document.querySelectorAll('.needs-validation');
    Array.from(forms).forEach(form => {
        form.addEventListener('submit', event => {
            if (!form.checkValidity()) {
                event.preventDefault();
                event.stopPropagation();
            }
            form.classList.add('was-validated');
        }, false);
    });
});
</script>
<?php $__env->stopPush(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\resources\views/currencies/currency-form.blade.php ENDPATH**/ ?>