

<?php $__env->startSection('title', 'Shipments'); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-body">
        <h4 class="header-title mb-3">Shipment List</h4>
<a href="<?php echo e(route('shipments.create')); ?>" class="btn btn-primary mb-3">+ New Shipment</a>
        <div class="table-responsive">
            <table class="table table-bordered align-middle table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Tracking</th>
                        <th>Customer</th>
                        <th>Mode</th>
                        <th>Category</th>
                        <th>Packages</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr class="accordion-toggle cursor-pointer" data-bs-toggle="collapse" data-bs-target="#summary-<?php echo e($shipment->id); ?>" aria-expanded="false">
                            <td><strong><?php echo e($shipment->main_tracking_no); ?></strong></td>
                            <td><?php echo e($shipment->customer->name); ?></td>
                            <td class="text-capitalize"><?php echo e(str_replace('_', ' ', $shipment->mode)); ?></td>
                            <td><?php echo e($shipment->category->name ?? '—'); ?></td>
                            <td><?php echo e($shipment->package_count); ?></td>
                            <td>
                                <a href="<?php echo e(route('shipments.edit', $shipment->id)); ?>" class="btn btn-sm btn-primary">Edit</a>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6" class="p-0">
                                <div id="summary-<?php echo e($shipment->id); ?>" class="collapse bg-light">
                                    <div class="p-3">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">📦 Package Details</h6>
                                                <ul class="mb-3">
                                                    <?php $__currentLoopData = $shipment->packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pkg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <li>
                                                            <?php echo e($pkg->tracking_no); ?> — 
                                                            <?php echo e($pkg->weight); ?> kg, 
                                                            <?php echo e($pkg->length); ?>×<?php echo e($pkg->width); ?>×<?php echo e($pkg->height); ?> cm
                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </ul>
                                            </div>
                                            <div class="col-md-6">
                                                <h6 class="fw-bold">🛠 Services</h6>
                                                <ul class="mb-3">
                                                    <?php $__empty_2 = true; $__currentLoopData = $shipment->services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $svc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                        <li>
                                                            <?php echo e($svc->service->name); ?> — 
                                                            <?php echo e(number_format($svc->cost_amount, 2)); ?> <?php echo e($svc->costCurrency->code ?? ''); ?>

                                                        </li>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                        <li>No additional services</li>
                                                    <?php endif; ?>
                                                </ul>
                                            </div>
                                        </div>
                                        <div>
                                            <a href="<?php echo e(asset('storage/labels/' . $shipment->packages->first()->label_filename)); ?>" target="_blank" class="btn btn-sm btn-secondary">
                                                📄 View Label
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="6" class="text-center text-muted">No shipments found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\resources\views/shipments/index.blade.php ENDPATH**/ ?>