

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customer Lifetime Value Report</h4>
            <div>
                <a href="<?php echo e(route('customer-reports.index')); ?>" class="btn btn-secondary me-2">
                    <i class="ri-arrow-left-line"></i> Back to Reports
                </a>
                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-primary">
                    <i class="ri-user-line"></i> Customers
                </a>
            </div>
        </div>

        <!-- Lifetime Value Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6>Total Customers</h6>
                        <h3><?php echo e($stats['total_customers']); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6>Total Revenue</h6>
                        <h3>$<?php echo e(number_format($stats['total_revenue'], 2)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h6>Avg. Lifetime Value</h6>
                        <h3>$<?php echo e(number_format($stats['average_lifetime_value'], 2)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h6>Top Customer</h6>
                        <h6><?php echo e($stats['top_customer']->name ?? 'N/A'); ?></h6>
                        <h6>$<?php echo e(number_format($stats['top_customer']->total_revenue ?? 0, 2)); ?></h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Customer Segments -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Customer Value Segments</h6>
                        <div class="row text-center">
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">Platinum</h6>
                                    <h5 class="text-primary">$5,000+</h5>
                                    <p class="mb-0"><?php echo e($customers->where('total_revenue', '>=', 5000)->count()); ?></p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">Gold</h6>
                                    <h5 class="text-warning">$1,000+</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [1000, 4999])->count()); ?></p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">Silver</h6>
                                    <h5 class="text-secondary">$500+</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [500, 999])->count()); ?></p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">Bronze</h6>
                                    <h5 class="text-bronze">$100+</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [100, 499])->count()); ?></p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">New</h6>
                                    <h5 class="text-success">$1+</h5>
                                    <p class="mb-0"><?php echo e($customers->whereBetween('total_revenue', [1, 99])->count()); ?></p>
                                </div>
                            </div>
                            <div class="col-md-2">
                                <div class="border rounded p-2">
                                    <h6 class="text-muted">Prospect</h6>
                                    <h5 class="text-muted">$0</h5>
                                    <p class="mb-0"><?php echo e($customers->where('total_revenue', 0)->count()); ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Lifetime Value Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Customer</th>
                                <th>Customer Type</th>
                                <th>Lifetime Value</th>
                                <th>Shipments</th>
                                <th>Avg. Order Value</th>
                                <th>Customer Since</th>
                                <th>Last Activity</th>
                                <th>Value Segment</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $segment = 'Prospect';
                                $segmentClass = 'secondary';
                                if ($customer->total_revenue >= 5000) {
                                    $segment = 'Platinum';
                                    $segmentClass = 'primary';
                                } elseif ($customer->total_revenue >= 1000) {
                                    $segment = 'Gold';
                                    $segmentClass = 'warning';
                                } elseif ($customer->total_revenue >= 500) {
                                    $segment = 'Silver';
                                    $segmentClass = 'secondary';
                                } elseif ($customer->total_revenue >= 100) {
                                    $segment = 'Bronze';
                                    $segmentClass = 'bronze';
                                } elseif ($customer->total_revenue >= 1) {
                                    $segment = 'New';
                                    $segmentClass = 'success';
                                }
                            ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-<?php echo e($segmentClass); ?> rounded-circle text-white d-flex align-items-center justify-content-center me-2" 
                                             style="width: 32px; height: 32px;">
                                            <?php echo e(strtoupper(substr($customer->name, 0, 1))); ?>

                                        </div>
                                        <div>
                                            <strong><?php echo e($customer->name); ?></strong>
                                            <?php if($customer->company_name): ?>
                                                <br><small class="text-muted"><?php echo e($customer->company_name); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($customer->customer_type == 'business' ? 'info' : ($customer->customer_type == 'corporate' ? 'primary' : 'secondary')); ?>">
                                        <?php echo e(ucfirst($customer->customer_type)); ?>

                                    </span>
                                </td>
                                <td class="text-success">
                                    <strong>$<?php echo e(number_format($customer->total_revenue, 2)); ?></strong>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark"><?php echo e($customer->total_shipments); ?></span>
                                </td>
                                <td>
                                    $<?php echo e(number_format($customer->average_shipment_value, 2)); ?>

                                </td>
                                <td>
                                    <?php echo e($customer->first_shipment_date ? $customer->first_shipment_date->format('M d, Y') : $customer->created_at->format('M d, Y')); ?>

                                </td>
                                <td>
                                    <?php echo e($customer->last_shipment_date ? $customer->last_shipment_date->format('M d, Y') : 'No shipments'); ?>

                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($segmentClass); ?>"><?php echo e($segment); ?></span>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Value Distribution Charts -->
        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Revenue Distribution by Segment</h6>
                        <canvas id="revenueSegmentChart" height="250"></canvas>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body">
                        <h6 class="card-title">Customer Distribution by Segment</h6>
                        <canvas id="customerSegmentChart" height="250"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Revenue by Segment Chart
    const revenueSegmentCtx = document.getElementById('revenueSegmentChart').getContext('2d');
    new Chart(revenueSegmentCtx, {
        type: 'bar',
        data: {
            labels: ['Platinum', 'Gold', 'Silver', 'Bronze', 'New', 'Prospect'],
            datasets: [{
                label: 'Total Revenue',
                data: [
                    <?php echo e($customers->where('total_revenue', '>=', 5000)->sum('total_revenue')); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [1000, 4999])->sum('total_revenue')); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [500, 999])->sum('total_revenue')); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [100, 499])->sum('total_revenue')); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [1, 99])->sum('total_revenue')); ?>,
                    <?php echo e($customers->where('total_revenue', 0)->sum('total_revenue')); ?>

                ],
                backgroundColor: ['#0d6efd', '#ffc107', '#6c757d', '#cd7f32', '#198754', '#6c757d']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return '$' + value.toLocaleString();
                        }
                    }
                }
            }
        }
    });

    // Customers by Segment Chart
    const customerSegmentCtx = document.getElementById('customerSegmentChart').getContext('2d');
    new Chart(customerSegmentCtx, {
        type: 'doughnut',
        data: {
            labels: ['Platinum', 'Gold', 'Silver', 'Bronze', 'New', 'Prospect'],
            datasets: [{
                data: [
                    <?php echo e($customers->where('total_revenue', '>=', 5000)->count()); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [1000, 4999])->count()); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [500, 999])->count()); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [100, 499])->count()); ?>,
                    <?php echo e($customers->whereBetween('total_revenue', [1, 99])->count()); ?>,
                    <?php echo e($customers->where('total_revenue', 0)->count()); ?>

                ],
                backgroundColor: ['#0d6efd', '#ffc107', '#6c757d', '#cd7f32', '#198754', '#6c757d']
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'bottom'
                }
            }
        }
    });
});
</script>

<style>
.avatar-sm {
    font-size: 14px;
    font-weight: bold;
}
.bg-bronze {
    background-color: #cd7f32 !important;
}
.text-bronze {
    color: #cd7f32 !important;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/customers/reports/lifetime-value.blade.php ENDPATH**/ ?>