<?php
    $packageCount = count($packages) > 0 ? count($packages) : 1;
    $unitType = $shipment->shipmentMode->measure->code ?? 'KG';
    
    // Calculate initial summary values
    $totalGrossWeight = $packages->sum('weight');
    $totalVolumeWeight = $packages->sum(function($pkg) {
        return ($pkg->length * $pkg->width * $pkg->height) / 6000;
    });
    
    if($unitType === 'CBM') {
        $totalChargeable = $packages->sum(function($pkg) {
            return ($pkg->length * $pkg->width * $pkg->height) / 1000000;
        });
        $chargeableDisplay = number_format($totalChargeable, 4) . ' CBM';
    } elseif($unitType === 'CUFT') {
        $totalChargeable = $packages->sum(function($pkg) {
            return ($pkg->length * $pkg->width * $pkg->height) / 28316.8466;
        });
        $chargeableDisplay = number_format($totalChargeable, 4) . ' CUFT';
    } else {
        $totalChargeable = $packages->sum(function($pkg) {
            return max(($pkg->length * $pkg->width * $pkg->height) / 6000, $pkg->weight);
        });
        $chargeableDisplay = number_format($totalChargeable, 2) . ' kg';
    }
?>

<div class="card mb-4 card-section">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>Package Details</span>
        <div class="d-flex align-items-center">
            <div class="me-3">
                <button id="addPackageBtn" class="btn btn-sm btn-primary">
                    <i class="ri-add-line"></i> Add Package
                </button>
                <button id="removePackageBtn" class="btn btn-sm btn-danger ms-2" disabled>
                    <i class="ri-subtract-line"></i> Remove
                </button>
            </div>
            <div class="col-md-3">
                <label for="numPieces" class="form-label">Number of Packages</label>
                <input type="number" id="numPieces" class="form-control" min="1" 
                       value="<?php echo e($packageCount); ?>" required>
            </div>
        </div>
    </div>
    <div class="card-body">
        <h5 class="section-title">Package Information</h5>
        <div id="packageContainer">
            <?php for($i = 0; $i < $packageCount; $i++): ?>
                <?php
                    $package = $packages[$i] ?? null;
                    $dimensions = $package ? [
                        'length' => $package->length,
                        'width' => $package->width,
                        'height' => $package->height,
                        'weight' => $package->weight,
                        'unit_type' => $unitType
                    ] : [
                        'length' => old("packages.$i.length", ''),
                        'width' => old("packages.$i.width", ''),
                        'height' => old("packages.$i.height", ''),
                        'weight' => old("packages.$i.weight", ''),
                        'unit_type' => $unitType
                    ];
                    
                    $showCalculations = $package || 
                        (old("packages.$i.length") || old("packages.$i.width") || 
                         old("packages.$i.height") || old("packages.$i.weight"));
                ?>
                <div class="package-row mb-3 p-3 border rounded" data-index="<?php echo e($i); ?>">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="mb-0">Package <?php echo e($i + 1); ?></h6>
                        <button type="button" class="btn btn-sm btn-outline-danger remove-single-package" title="Remove this package">
                            <i class="ri-delete-bin-line"></i>
                        </button>
                    </div>
                    <div class="row">
                        <div class="col-md-3 mb-2">
                            <label>Length (cm)</label>
                            <input name="packages[<?php echo e($i); ?>][length]" class="form-control length" 
                                   value="<?php echo e($dimensions['length']); ?>" required>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label>Width (cm)</label>
                            <input name="packages[<?php echo e($i); ?>][width]" class="form-control width" 
                                   value="<?php echo e($dimensions['width']); ?>" required>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label>Height (cm)</label>
                            <input name="packages[<?php echo e($i); ?>][height]" class="form-control height" 
                                   value="<?php echo e($dimensions['height']); ?>" required>
                        </div>
                        <div class="col-md-3 mb-2">
                            <label>Weight (kg)</label>
                            <input name="packages[<?php echo e($i); ?>][weight]" class="form-control weight" 
                                   value="<?php echo e($dimensions['weight']); ?>" required>
                        </div>
                    </div>
                    <div class="calculation-section <?php echo e($showCalculations ? '' : 'd-none'); ?>">
                        <div class="row mt-2">
                            <div class="col-md-6">
                                <div class="alert alert-info p-2 mb-0">
                                    <small>
                                        Volume: <span class="volume-display">
                                            <?php if($showCalculations): ?>
                                                <?php echo e(number_format($dimensions['length'] * $dimensions['width'] * $dimensions['height'], 2)); ?>

                                            <?php else: ?>
                                                0.00
                                            <?php endif; ?>
                                        </span> cm³<br>
                                        Vol. Weight: <span class="vol-weight-display">
                                            <?php if($showCalculations): ?>
                                                <?php echo e(number_format(($dimensions['length'] * $dimensions['width'] * $dimensions['height']) / 6000, 2)); ?>

                                            <?php else: ?>
                                                0.00
                                            <?php endif; ?>
                                        </span> kg<br>
                                        Chargeable: <span class="chargeable-weight-display">
                                            <?php if($showCalculations): ?>
                                                <?php if($unitType === 'CBM'): ?>
                                                    <?php echo e(number_format(($dimensions['length'] * $dimensions['width'] * $dimensions['height']) / 1000000, 4)); ?> CBM
                                                <?php elseif($unitType === 'CUFT'): ?>
                                                    <?php echo e(number_format(($dimensions['length'] * $dimensions['width'] * $dimensions['height']) / 28316.8466, 4)); ?> CUFT
                                                <?php else: ?>
                                                    <?php echo e(number_format(max(($dimensions['length'] * $dimensions['width'] * $dimensions['height']) / 6000, $dimensions['weight']), 2)); ?> kg
                                                <?php endif; ?>
                                            <?php else: ?>
                                                0.00 <?php echo e($unitType === 'CBM' ? 'CBM' : ($unitType === 'CUFT' ? 'CUFT' : 'kg')); ?>

                                            <?php endif; ?>
                                        </span>
                                    </small>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <input type="file" name="packages[<?php echo e($i); ?>][images][]" multiple class="form-control form-control-sm" accept="image/*">
                            </div>
                        </div>
                    </div>
                </div>
            <?php endfor; ?>
        </div>
        
        <!-- Summary Section -->
        <div class="row mt-4">
            <div class="col-md-4 mb-3">
                <label>Total Gross Weight</label>
                <input type="text" id="totalGrossWeight" class="form-control" readonly
                       value="<?php echo e(number_format($totalGrossWeight, 2)); ?> kg">
            </div>
            <div class="col-md-4 mb-3">
                <label>Total Volume Weight</label>
                <input type="text" id="totalVolumeWeight" class="form-control" readonly
                       value="<?php echo e(number_format($totalVolumeWeight, 2)); ?> kg">
            </div>
            <div class="col-md-4 mb-3">
                <label>Chargeable Weight</label>
                <input type="text" id="totalChargeableWeight" class="form-control" readonly
                       value="<?php echo e($chargeableDisplay); ?>">
            </div>
        </div>

        <!-- Freight Calculation Section -->
            <div class="row mt-4">
                <div class="col-md-4 mb-3">
                    <div class="card bg-light h-100">
                        <div class="card-body">
                            <h6 class="card-title">Applicable Rate</h6>
                            <div id="rateDisplay">
                                <p class="mb-1"><strong>0.00 KES/kg</strong></p>
                                <small class="text-muted">Select route to see rate</small>
                            </div>
                            <div class="mt-2">
                                <small class="text-muted d-block" id="minWeightInfo">
                                    Minimum chargeable weight: 0 kg
                                </small>
                                <small class="text-muted d-block" id="weightBasisInfo">
                                    Charged on higher of gross/volumetric
                                </small>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <label>Total Chargeable Weight</label>
                    <input type="text" id="finalChargeableWeight" class="form-control" readonly
                        value="<?php echo e($chargeableDisplay); ?>">
                    <small class="text-muted" id="chargeableInfo">
                        Calculated based on packages
                    </small>
                </div>
                <div class="col-md-4 mb-3">
                    <label>Total Freight Charges</label>
                    <div class="input-group">
                        <input type="text" id="totalFreightCharges" class="form-control" readonly value="0.00">
                        <span class="input-group-text" id="freightCurrency">KES</span>
                    </div>
                    <small class="text-muted" id="freightInfo">
                        Calculated based on chargeable weight
                    </small>
                </div>
            </div>
    </div>
</div><?php /**PATH C:\MAMP\htdocs\smart-shipping\resources\views/shipments/partials/package-details.blade.php ENDPATH**/ ?>