

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customer Activity Report</h4>
            <div>
                <a href="<?php echo e(route('customer-reports.index')); ?>" class="btn btn-secondary me-2">
                    <i class="ri-arrow-left-line"></i> Back to Reports
                </a>
                <a href="<?php echo e(route('customers.index')); ?>" class="btn btn-primary">
                    <i class="ri-user-line"></i> Customers
                </a>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-4">
                        <label class="form-label">Customer</label>
                        <select name="customer_id" class="form-select">
                            <option value="">All Customers</option>
                            <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($customer->id); ?>" <?php echo e(request('customer_id') == $customer->id ? 'selected' : ''); ?>>
                                    <?php echo e($customer->name); ?> - <?php echo e($customer->phone); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">Activity Period</label>
                        <select name="days" class="form-select">
                            <option value="7" <?php echo e($days == 7 ? 'selected' : ''); ?>>Last 7 Days</option>
                            <option value="30" <?php echo e($days == 30 ? 'selected' : ''); ?>>Last 30 Days</option>
                            <option value="90" <?php echo e($days == 90 ? 'selected' : ''); ?>>Last 90 Days</option>
                            <option value="365" <?php echo e($days == 365 ? 'selected' : ''); ?>>Last Year</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Generate Report</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Activity Summary -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body text-center">
                        <h6>Active Customers</h6>
                        <h3><?php echo e($customers->where('activities_count', '>', 0)->count()); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body text-center">
                        <h6>Total Activities</h6>
                        <h3><?php echo e($customers->sum('activities_count')); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body text-center">
                        <h6>Avg. Activities/Customer</h6>
                        <h3><?php echo e(number_format($customers->avg('activities_count'), 1)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body text-center">
                        <h6>Most Active</h6>
                        <h6><?php echo e($customers->sortByDesc('activities_count')->first()->name ?? 'N/A'); ?></h6>
                    </div>
                </div>
            </div>
        </div>

        <!-- Activity Table -->
        <div class="card">
            <div class="card-body">
                <?php if(request('customer_id')): ?>
                    <!-- Single Customer Detailed View -->
                    <?php $customer = $customers->firstWhere('id', request('customer_id')); ?>
                    <?php if($customer): ?>
                    <div class="mb-4 p-3 border rounded bg-light">
                        <h5>Customer: <?php echo e($customer->name); ?></h5>
                        <div class="row">
                            <div class="col-md-3"><strong>Phone:</strong> <?php echo e($customer->phone); ?></div>
                            <div class="col-md-3"><strong>Email:</strong> <?php echo e($customer->email ?? 'N/A'); ?></div>
                            <div class="col-md-3"><strong>Type:</strong> <?php echo e(ucfirst($customer->customer_type)); ?></div>
                            <div class="col-md-3"><strong>Status:</strong> <?php echo e(ucfirst($customer->status)); ?></div>
                        </div>
                    </div>

                    <h6 class="mb-3">Recent Activities (<?php echo e($customer->activities->count()); ?>)</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date & Time</th>
                                    <th>Activity Type</th>
                                    <th>Description</th>
                                    <th>Performed By</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $customer->activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($activity->performed_at->format('M d, Y H:i')); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo e($activity->activity_type == 'shipment_created' ? 'success' : ($activity->activity_type == 'payment_received' ? 'info' : 'secondary')); ?>">
                                            <?php echo e(str_replace('_', ' ', ucfirst($activity->activity_type))); ?>

                                        </span>
                                    </td>
                                    <td><?php echo e($activity->description); ?></td>
                                    <td><?php echo e($activity->performer->name ?? 'System'); ?></td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center text-muted py-4">
                                        No activities found for this period
                                    </td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php endif; ?>
                <?php else: ?>
                    <!-- All Customers Summary View -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Customer</th>
                                    <th>Contact</th>
                                    <th>Activities Count</th>
                                    <th>Last Activity</th>
                                    <th>Total Revenue</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td>
                                        <strong><?php echo e($customer->name); ?></strong>
                                        <?php if($customer->company_name): ?>
                                            <br><small class="text-muted"><?php echo e($customer->company_name); ?></small>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php echo e($customer->phone); ?><br>
                                        <small class="text-muted"><?php echo e($customer->email ?? 'N/A'); ?></small>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo e($customer->activities_count > 0 ? 'success' : 'secondary'); ?>">
                                            <?php echo e($customer->activities_count); ?> activities
                                        </span>
                                    </td>
                                    <td>
                                        <?php if($customer->activities->count() > 0): ?>
                                            <?php echo e($customer->activities->first()->performed_at->format('M d, Y')); ?>

                                            <br><small class="text-muted"><?php echo e($customer->activities->first()->activity_type); ?></small>
                                        <?php else: ?>
                                            <span class="text-muted">No activities</span>
                                        <?php endif; ?>
                                    </td>
                                    <td class="text-success">
                                        <strong>$<?php echo e(number_format($customer->total_revenue, 2)); ?></strong>
                                    </td>
                                    <td>
                                        <a href="<?php echo e(route('customer-reports.activity', ['customer_id' => $customer->id, 'days' => $days])); ?>" 
                                           class="btn btn-sm btn-info">
                                            <i class="ri-eye-line"></i> View Details
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/customers/reports/activity.blade.php ENDPATH**/ ?>