

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h4 class="mb-0">Customers</h4>
            <div>
                <a href="<?php echo e(route('customer-reports.index')); ?>" class="btn btn-info me-2">
                    <i class="ri-bar-chart-line"></i> Reports
                </a>
                <a href="<?php echo e(route('customers.create')); ?>" class="btn btn-primary">
                    <i class="ri-user-add-line"></i> New Customer
                </a>
            </div>
        </div>

        <!-- Customer Stats -->
        <div class="row mb-4">
            <div class="col-md-3">
                <div class="card bg-primary text-white">
                    <div class="card-body">
                        <h6 class="card-title">Total Customers</h6>
                        <h3><?php echo e($customers->count()); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-success text-white">
                    <div class="card-body">
                        <h6 class="card-title">Active Customers</h6>
                        <h3><?php echo e($customers->where('status', 'active')->count()); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-info text-white">
                    <div class="card-body">
                        <h6 class="card-title">Total Revenue</h6>
                        <h3>$<?php echo e(number_format($customers->sum('total_revenue'), 2)); ?></h3>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
                <div class="card bg-warning text-white">
                    <div class="card-body">
                        <h6 class="card-title">Avg. Value</h6>
                        <h3>$<?php echo e(number_format($customers->avg('total_revenue'), 2)); ?></h3>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filters -->
        <div class="card mb-4">
            <div class="card-body">
                <form method="GET" class="row g-3">
                    <div class="col-md-3">
                        <label class="form-label">Customer Type</label>
                        <select name="customer_type" class="form-select">
                            <option value="">All Types</option>
                            <option value="individual" <?php echo e(request('customer_type') == 'individual' ? 'selected' : ''); ?>>Individual</option>
                            <option value="business" <?php echo e(request('customer_type') == 'business' ? 'selected' : ''); ?>>Business</option>
                            <option value="corporate" <?php echo e(request('customer_type') == 'corporate' ? 'selected' : ''); ?>>Corporate</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Status</label>
                        <select name="status" class="form-select">
                            <option value="">All Status</option>
                            <option value="active" <?php echo e(request('status') == 'active' ? 'selected' : ''); ?>>Active</option>
                            <option value="inactive" <?php echo e(request('status') == 'inactive' ? 'selected' : ''); ?>>Inactive</option>
                            <option value="blocked" <?php echo e(request('status') == 'blocked' ? 'selected' : ''); ?>>Blocked</option>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">Search</label>
                        <input type="text" name="search" class="form-control" placeholder="Name or Phone..." value="<?php echo e(request('search')); ?>">
                    </div>
                    <div class="col-md-3">
                        <label class="form-label">&nbsp;</label>
                        <div class="d-grid">
                            <button type="submit" class="btn btn-primary">Filter</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Customers Table -->
        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead class="table-light">
                            <tr>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Type</th>
                                <th>Revenue</th>
                                <th>Shipments</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div class="avatar-sm bg-primary rounded-circle text-white d-flex align-items-center justify-content-center me-2" style="width: 32px; height: 32px;">
                                            <?php echo e(strtoupper(substr($customer->name, 0, 1))); ?>

                                        </div>
                                        <div>
                                            <strong><?php echo e($customer->name); ?></strong>
                                            <?php if($customer->company_name): ?>
                                                <br><small class="text-muted"><?php echo e($customer->company_name); ?></small>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </td>
                                <td><?php echo e($customer->phone); ?></td>
                                <td><?php echo e($customer->email ?? 'N/A'); ?></td>
                                <td>
                                    <span class="badge bg-<?php echo e($customer->customer_type == 'business' ? 'info' : ($customer->customer_type == 'corporate' ? 'primary' : 'secondary')); ?>">
                                        <?php echo e(ucfirst($customer->customer_type)); ?>

                                    </span>
                                </td>
                                <td>
                                    <strong class="text-success">$<?php echo e(number_format($customer->total_revenue, 2)); ?></strong>
                                    <?php if($customer->total_shipments > 0): ?>
                                        <br><small class="text-muted">Avg: $<?php echo e(number_format($customer->average_shipment_value, 2)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-light text-dark"><?php echo e($customer->total_shipments); ?></span>
                                    <?php if($customer->last_shipment_date): ?>
                                        <br><small class="text-muted">Last: <?php echo e($customer->last_shipment_date->format('M d, Y')); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?php echo e($customer->status == 'active' ? 'success' : ($customer->status == 'blocked' ? 'danger' : 'warning')); ?>">
                                        <?php echo e(ucfirst($customer->status)); ?>

                                    </span>
                                </td>
                                <td>
                                    <div class="btn-group">
                                        <a href="<?php echo e(route('customers.edit', $customer)); ?>" class="btn btn-sm btn-warning">
                                            <i class="ri-edit-line"></i> Edit
                                        </a>
                                        <a href="<?php echo e(route('customer-reports.activity', ['customer_id' => $customer->id])); ?>" class="btn btn-sm btn-info">
                                            <i class="ri-history-line"></i> Activity
                                        </a>
                                        <form action="<?php echo e(route('customers.destroy', $customer)); ?>" method="POST" class="d-inline">
                                            <?php echo csrf_field(); ?> 
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">
                                                <i class="ri-delete-bin-line"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">
                                    <i class="ri-user-search-line display-4"></i>
                                    <p class="mt-2">No customers found</p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <?php if($customers->hasPages()): ?>
                <div class="d-flex justify-content-between align-items-center mt-3">
                    <div class="text-muted">
                        Showing <?php echo e($customers->firstItem()); ?> to <?php echo e($customers->lastItem()); ?> of <?php echo e($customers->total()); ?> entries
                    </div>
                    <?php echo e($customers->links()); ?>

                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('styles'); ?>
<style>
.avatar-sm {
    font-size: 14px;
    font-weight: bold;
}
</style>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.clivax', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\smart-shipping\smart-shipping\resources\views/customers/index.blade.php ENDPATH**/ ?>